/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PluginPropertyJson;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.util.audit.AuditLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApiModel(description="Payment transaction")
public class PaymentTransactionJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID")
    private final String transactionId;
    private final String transactionExternalKey;
    @ApiModelProperty(value="Associated payment id, required when notifying state transitions", dataType="java.util.UUID")
    private final String paymentId;
    private final String paymentExternalKey;
    @ApiModelProperty(dataType="org.killbill.billing.payment.api.TransactionType")
    private final String transactionType;
    @ApiModelProperty(dataType="org.joda.time.DateTime")
    private final DateTime effectiveDate;
    @ApiModelProperty(value="Transaction status, required for state change notifications", dataType="org.killbill.billing.payment.api.TransactionStatus")
    private final String status;
    @ApiModelProperty(value="Transaction amount, required except for void operations")
    private final BigDecimal amount;
    @ApiModelProperty(value="Amount currency (account currency unless specified)", dataType="org.killbill.billing.catalog.api.Currency")
    private final String currency;
    private final String gatewayErrorCode;
    private final String gatewayErrorMsg;
    private final String firstPaymentReferenceId;
    private final String secondPaymentReferenceId;
    private final List<PluginPropertyJson> properties;

    @JsonCreator
    public PaymentTransactionJson(@JsonProperty(value="transactionId") String transactionId, @JsonProperty(value="transactionExternalKey") String transactionExternalKey, @JsonProperty(value="paymentId") String paymentId, @JsonProperty(value="paymentExternalKey") String paymentExternalKey, @JsonProperty(value="transactionType") String transactionType, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") String currency, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="status") String status, @JsonProperty(value="gatewayErrorCode") String gatewayErrorCode, @JsonProperty(value="gatewayErrorMsg") String gatewayErrorMsg, @JsonProperty(value="firstPaymentReferenceId") String firstPaymentReferenceId, @JsonProperty(value="secondPaymentReferenceId") String secondPaymentReferenceId, @JsonProperty(value="properties") List<PluginPropertyJson> properties, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.transactionId = transactionId;
        this.transactionExternalKey = transactionExternalKey;
        this.paymentId = paymentId;
        this.paymentExternalKey = paymentExternalKey;
        this.transactionType = transactionType;
        this.effectiveDate = effectiveDate;
        this.status = status;
        this.amount = amount;
        this.currency = currency;
        this.gatewayErrorCode = gatewayErrorCode;
        this.gatewayErrorMsg = gatewayErrorMsg;
        this.firstPaymentReferenceId = firstPaymentReferenceId;
        this.secondPaymentReferenceId = secondPaymentReferenceId;
        this.properties = properties;
    }

    public PaymentTransactionJson(PaymentTransaction transaction, String paymentExternalKey, @Nullable List<AuditLog> transactionLogs) {
        this(transaction.getId().toString(), transaction.getExternalKey(), transaction.getPaymentId().toString(), paymentExternalKey, transaction.getTransactionType().toString(), transaction.getAmount(), transaction.getCurrency() != null ? transaction.getCurrency().toString() : null, transaction.getEffectiveDate(), transaction.getTransactionStatus() != null ? transaction.getTransactionStatus().toString() : null, transaction.getGatewayErrorCode(), transaction.getGatewayErrorMsg(), transaction.getPaymentInfoPlugin() == null ? null : transaction.getPaymentInfoPlugin().getFirstPaymentReferenceId(), transaction.getPaymentInfoPlugin() == null ? null : transaction.getPaymentInfoPlugin().getSecondPaymentReferenceId(), transaction.getPaymentInfoPlugin() == null ? null : PaymentTransactionJson.toPluginPropertyJson(transaction.getPaymentInfoPlugin().getProperties()), (List<AuditLogJson>)PaymentTransactionJson.toAuditLogJson(transactionLogs));
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getTransactionExternalKey() {
        return this.transactionExternalKey;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public String getStatus() {
        return this.status;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getGatewayErrorCode() {
        return this.gatewayErrorCode;
    }

    public String getGatewayErrorMsg() {
        return this.gatewayErrorMsg;
    }

    public String getFirstPaymentReferenceId() {
        return this.firstPaymentReferenceId;
    }

    public String getSecondPaymentReferenceId() {
        return this.secondPaymentReferenceId;
    }

    public List<PluginPropertyJson> getProperties() {
        return this.properties;
    }

    public String getPaymentExternalKey() {
        return this.paymentExternalKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PaymentTransactionJson{");
        sb.append("transactionId='").append(this.transactionId).append('\'');
        sb.append(", paymentId='").append(this.paymentId).append('\'');
        sb.append(", transactionExternalKey='").append(this.transactionExternalKey).append('\'');
        sb.append(", transactionType='").append(this.transactionType).append('\'');
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", status='").append(this.status).append('\'');
        sb.append(", amount=").append(this.amount);
        sb.append(", currency='").append(this.currency).append('\'');
        sb.append(", gatewayErrorCode='").append(this.gatewayErrorCode).append('\'');
        sb.append(", gatewayErrorMsg='").append(this.gatewayErrorMsg).append('\'');
        sb.append(", firstPaymentReferenceId='").append(this.firstPaymentReferenceId).append('\'');
        sb.append(", secondPaymentReferenceId='").append(this.secondPaymentReferenceId).append('\'');
        sb.append(", properties=").append(this.properties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentTransactionJson that = (PaymentTransactionJson)o;
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.transactionExternalKey != null ? !this.transactionExternalKey.equals(that.transactionExternalKey) : that.transactionExternalKey != null) {
            return false;
        }
        if (this.paymentId != null ? !this.paymentId.equals(that.paymentId) : that.paymentId != null) {
            return false;
        }
        if (this.transactionId != null ? !this.transactionId.equals(that.transactionId) : that.transactionId != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.firstPaymentReferenceId != null ? !this.firstPaymentReferenceId.equals(that.firstPaymentReferenceId) : that.firstPaymentReferenceId != null) {
            return false;
        }
        if (this.gatewayErrorCode != null ? !this.gatewayErrorCode.equals(that.gatewayErrorCode) : that.gatewayErrorCode != null) {
            return false;
        }
        if (this.gatewayErrorMsg != null ? !this.gatewayErrorMsg.equals(that.gatewayErrorMsg) : that.gatewayErrorMsg != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.secondPaymentReferenceId != null ? !this.secondPaymentReferenceId.equals(that.secondPaymentReferenceId) : that.secondPaymentReferenceId != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.transactionType != null ? !this.transactionType.equals(that.transactionType) : that.transactionType != null);
    }

    public int hashCode() {
        int result = this.transactionId != null ? this.transactionId.hashCode() : 0;
        result = 31 * result + (this.paymentId != null ? this.paymentId.hashCode() : 0);
        result = 31 * result + (this.transactionExternalKey != null ? this.transactionExternalKey.hashCode() : 0);
        result = 31 * result + (this.transactionType != null ? this.transactionType.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.gatewayErrorCode != null ? this.gatewayErrorCode.hashCode() : 0);
        result = 31 * result + (this.gatewayErrorMsg != null ? this.gatewayErrorMsg.hashCode() : 0);
        result = 31 * result + (this.firstPaymentReferenceId != null ? this.firstPaymentReferenceId.hashCode() : 0);
        result = 31 * result + (this.secondPaymentReferenceId != null ? this.secondPaymentReferenceId.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

