/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PluginPropertyJson;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethodJson
extends JsonBase {
    private final String externalKey;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String paymentMethodId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String accountId;
    private final Boolean isDefault;
    private final String pluginName;
    private final PaymentMethodPluginDetailJson pluginInfo;

    @JsonCreator
    public PaymentMethodJson(@JsonProperty(value="paymentMethodId") String paymentMethodId, @JsonProperty(value="externalKey") String externalKey, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="isDefault") Boolean isDefault, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="pluginInfo") @Nullable PaymentMethodPluginDetailJson pluginInfo, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.externalKey = externalKey;
        this.paymentMethodId = paymentMethodId;
        this.accountId = accountId;
        this.isDefault = isDefault;
        this.pluginName = pluginName;
        this.pluginInfo = pluginInfo;
    }

    public static PaymentMethodJson toPaymentMethodJson(Account account, PaymentMethod in, @Nullable AccountAuditLogs accountAuditLogs) {
        boolean isDefault = account.getPaymentMethodId() != null && account.getPaymentMethodId().equals(in.getId());
        PaymentMethodPlugin pluginDetail = in.getPluginDetail();
        PaymentMethodPluginDetailJson pluginDetailJson = null;
        if (pluginDetail != null) {
            ArrayList properties = null;
            if (pluginDetail.getProperties() != null) {
                properties = new ArrayList(Collections2.transform((Collection)pluginDetail.getProperties(), (Function)new Function<PluginProperty, PluginPropertyJson>(){

                    public PluginPropertyJson apply(PluginProperty input) {
                        return new PluginPropertyJson(input.getKey(), input.getValue() == null ? null : input.getValue().toString(), input.getIsUpdatable());
                    }
                }));
            }
            pluginDetailJson = new PaymentMethodPluginDetailJson(pluginDetail.getExternalPaymentMethodId(), pluginDetail.isDefaultPaymentMethod(), properties);
        }
        return new PaymentMethodJson(in.getId().toString(), in.getExternalKey(), account.getId().toString(), isDefault, in.getPluginName(), pluginDetailJson, (List<AuditLogJson>)PaymentMethodJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForPaymentMethod(in.getId())));
    }

    public PaymentMethod toPaymentMethod(final String accountId) {
        return new PaymentMethod(){

            public Boolean isActive() {
                return true;
            }

            public String getPluginName() {
                return PaymentMethodJson.this.pluginName;
            }

            public UUID getId() {
                return PaymentMethodJson.this.paymentMethodId != null ? UUID.fromString(PaymentMethodJson.this.paymentMethodId) : null;
            }

            public String getExternalKey() {
                return PaymentMethodJson.this.externalKey;
            }

            public DateTime getCreatedDate() {
                return null;
            }

            public DateTime getUpdatedDate() {
                return null;
            }

            public UUID getAccountId() {
                return UUID.fromString(accountId);
            }

            public PaymentMethodPlugin getPluginDetail() {
                return new PaymentMethodPlugin(){

                    public UUID getKbPaymentMethodId() {
                        return PaymentMethodJson.this.paymentMethodId == null ? null : UUID.fromString(PaymentMethodJson.this.paymentMethodId);
                    }

                    public boolean isDefaultPaymentMethod() {
                        return false;
                    }

                    public String getExternalPaymentMethodId() {
                        return PaymentMethodJson.this.pluginInfo != null ? PaymentMethodJson.this.pluginInfo.getExternalPaymentMethodId() : null;
                    }

                    public List<PluginProperty> getProperties() {
                        if (PaymentMethodJson.this.pluginInfo != null && PaymentMethodJson.this.pluginInfo.getProperties() != null) {
                            LinkedList<PluginProperty> result = new LinkedList<PluginProperty>();
                            for (PluginPropertyJson cur : PaymentMethodJson.this.pluginInfo.getProperties()) {
                                result.add(new PluginProperty(cur.getKey(), (Object)cur.getValue(), cur.getIsUpdatable()));
                            }
                            return result;
                        }
                        return null;
                    }
                };
            }
        };
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="isDefault")
    public Boolean isDefault() {
        return this.isDefault;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public PaymentMethodPluginDetailJson getPluginInfo() {
        return this.pluginInfo;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PaymentMethodJson{");
        sb.append("paymentMethodId='").append(this.paymentMethodId).append('\'');
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append(", isDefault=").append(this.isDefault);
        sb.append(", pluginName='").append(this.pluginName).append('\'');
        sb.append(", pluginInfo=").append(this.pluginInfo);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodJson that = (PaymentMethodJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.isDefault != null ? !this.isDefault.equals(that.isDefault) : that.isDefault != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.pluginInfo != null ? !this.pluginInfo.equals(that.pluginInfo) : that.pluginInfo != null) {
            return false;
        }
        return !(this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null);
    }

    public int hashCode() {
        int result = this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0;
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.isDefault != null ? this.isDefault.hashCode() : 0);
        result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
        result = 31 * result + (this.pluginInfo != null ? this.pluginInfo.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PaymentMethodPluginDetailJson {
        private final String externalPaymentMethodId;
        private final Boolean isDefaultPaymentMethod;
        private final List<PluginPropertyJson> properties;

        @JsonCreator
        public PaymentMethodPluginDetailJson(@JsonProperty(value="externalPaymentMethodId") String externalPaymentMethodId, @JsonProperty(value="isDefaultPaymentMethod") Boolean isDefaultPaymentMethod, @JsonProperty(value="properties") List<PluginPropertyJson> properties) {
            this.externalPaymentMethodId = externalPaymentMethodId;
            this.isDefaultPaymentMethod = isDefaultPaymentMethod;
            this.properties = properties;
        }

        public String getExternalPaymentMethodId() {
            return this.externalPaymentMethodId;
        }

        public Boolean getIsDefaultPaymentMethod() {
            return this.isDefaultPaymentMethod;
        }

        public List<PluginPropertyJson> getProperties() {
            return this.properties;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PaymentMethodPluginDetailJson{");
            sb.append("externalPaymentMethodId='").append(this.externalPaymentMethodId).append('\'');
            sb.append(", isDefaultPaymentMethod=").append(this.isDefaultPaymentMethod);
            sb.append(", properties=").append(this.properties);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaymentMethodPluginDetailJson that = (PaymentMethodPluginDetailJson)o;
            if (this.externalPaymentMethodId != null ? !this.externalPaymentMethodId.equals(that.externalPaymentMethodId) : that.externalPaymentMethodId != null) {
                return false;
            }
            if (this.isDefaultPaymentMethod != null ? !this.isDefaultPaymentMethod.equals(that.isDefaultPaymentMethod) : that.isDefaultPaymentMethod != null) {
                return false;
            }
            return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
        }

        public int hashCode() {
            int result = this.externalPaymentMethodId != null ? this.externalPaymentMethodId.hashCode() : 0;
            result = 31 * result + (this.isDefaultPaymentMethod != null ? this.isDefaultPaymentMethod.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            return result;
        }
    }
}

