/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.PaymentTransactionJson;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentTransaction;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID")
    private final String accountId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String paymentId;
    private final String paymentNumber;
    private final String paymentExternalKey;
    private final BigDecimal authAmount;
    private final BigDecimal capturedAmount;
    private final BigDecimal purchasedAmount;
    private final BigDecimal refundedAmount;
    private final BigDecimal creditedAmount;
    private final String currency;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String paymentMethodId;
    private final List<? extends PaymentTransactionJson> transactions;

    @JsonCreator
    public PaymentJson(@JsonProperty(value="accountId") String accountId, @JsonProperty(value="paymentId") String paymentId, @JsonProperty(value="paymentNumber") String paymentNumber, @JsonProperty(value="paymentExternalKey") String paymentExternalKey, @JsonProperty(value="authAmount") BigDecimal authAmount, @JsonProperty(value="capturedAmount") BigDecimal capturedAmount, @JsonProperty(value="purchasedAmount") BigDecimal purchasedAmount, @JsonProperty(value="refundedAmount") BigDecimal refundedAmount, @JsonProperty(value="creditedAmount") BigDecimal creditedAmount, @JsonProperty(value="currency") String currency, @JsonProperty(value="paymentMethodId") String paymentMethodId, @JsonProperty(value="transactions") List<? extends PaymentTransactionJson> transactions, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.paymentId = paymentId;
        this.paymentNumber = paymentNumber;
        this.paymentExternalKey = paymentExternalKey;
        this.authAmount = authAmount;
        this.capturedAmount = capturedAmount;
        this.purchasedAmount = purchasedAmount;
        this.refundedAmount = refundedAmount;
        this.creditedAmount = creditedAmount;
        this.currency = currency;
        this.paymentMethodId = paymentMethodId;
        this.transactions = transactions;
    }

    public PaymentJson(Payment dp, @Nullable AccountAuditLogs accountAuditLogs) {
        this(dp.getAccountId().toString(), dp.getId().toString(), dp.getPaymentNumber().toString(), dp.getExternalKey(), dp.getAuthAmount(), dp.getCapturedAmount(), dp.getPurchasedAmount(), dp.getRefundedAmount(), dp.getCreditedAmount(), dp.getCurrency() != null ? dp.getCurrency().toString() : null, dp.getPaymentMethodId() != null ? dp.getPaymentMethodId().toString() : null, (List<? extends PaymentTransactionJson>)PaymentJson.getTransactions(dp.getTransactions(), dp.getExternalKey(), accountAuditLogs), (List<AuditLogJson>)PaymentJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForPayment(dp.getId())));
    }

    private static List<PaymentTransactionJson> getTransactions(Iterable<PaymentTransaction> transactions, final String paymentExternalKey, final @Nullable AccountAuditLogs accountAuditLogs) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(transactions, (Function)new Function<PaymentTransaction, PaymentTransactionJson>(){

            public PaymentTransactionJson apply(PaymentTransaction paymentTransaction) {
                List auditLogsForPaymentTransaction = accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForPaymentTransaction(paymentTransaction.getId());
                return new PaymentTransactionJson(paymentTransaction, paymentExternalKey, auditLogsForPaymentTransaction);
            }
        }));
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getPaymentNumber() {
        return this.paymentNumber;
    }

    public String getPaymentExternalKey() {
        return this.paymentExternalKey;
    }

    public BigDecimal getAuthAmount() {
        return this.authAmount;
    }

    public BigDecimal getCapturedAmount() {
        return this.capturedAmount;
    }

    public BigDecimal getRefundedAmount() {
        return this.refundedAmount;
    }

    public BigDecimal getPurchasedAmount() {
        return this.purchasedAmount;
    }

    public BigDecimal getCreditedAmount() {
        return this.creditedAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public List<? extends PaymentTransactionJson> getTransactions() {
        return this.transactions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PaymentJson{");
        sb.append("accountId='").append(this.accountId).append('\'');
        sb.append(", paymentId='").append(this.paymentId).append('\'');
        sb.append(", paymentNumber='").append(this.paymentNumber).append('\'');
        sb.append(", paymentExternalKey='").append(this.paymentExternalKey).append('\'');
        sb.append(", authAmount=").append(this.authAmount);
        sb.append(", capturedAmount=").append(this.capturedAmount);
        sb.append(", purchasedAmount=").append(this.purchasedAmount);
        sb.append(", refundedAmount=").append(this.refundedAmount);
        sb.append(", creditedAmount=").append(this.creditedAmount);
        sb.append(", currency='").append(this.currency).append('\'');
        sb.append(", paymentMethodId='").append(this.paymentMethodId).append('\'');
        sb.append(", transactions=").append(this.transactions);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentJson that = (PaymentJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.authAmount != null ? this.authAmount.compareTo(that.authAmount) != 0 : that.authAmount != null) {
            return false;
        }
        if (this.capturedAmount != null ? this.capturedAmount.compareTo(that.capturedAmount) != 0 : that.capturedAmount != null) {
            return false;
        }
        if (this.creditedAmount != null ? this.creditedAmount.compareTo(that.creditedAmount) != 0 : that.creditedAmount != null) {
            return false;
        }
        if (this.purchasedAmount != null ? this.purchasedAmount.compareTo(that.purchasedAmount) != 0 : that.purchasedAmount != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.paymentExternalKey != null ? !this.paymentExternalKey.equals(that.paymentExternalKey) : that.paymentExternalKey != null) {
            return false;
        }
        if (this.paymentId != null ? !this.paymentId.equals(that.paymentId) : that.paymentId != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.paymentNumber != null ? !this.paymentNumber.equals(that.paymentNumber) : that.paymentNumber != null) {
            return false;
        }
        if (this.refundedAmount != null ? this.refundedAmount.compareTo(that.refundedAmount) != 0 : that.refundedAmount != null) {
            return false;
        }
        return !(this.transactions != null ? !this.transactions.equals(that.transactions) : that.transactions != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.paymentId != null ? this.paymentId.hashCode() : 0);
        result = 31 * result + (this.paymentNumber != null ? this.paymentNumber.hashCode() : 0);
        result = 31 * result + (this.paymentExternalKey != null ? this.paymentExternalKey.hashCode() : 0);
        result = 31 * result + (this.authAmount != null ? this.authAmount.hashCode() : 0);
        result = 31 * result + (this.capturedAmount != null ? this.capturedAmount.hashCode() : 0);
        result = 31 * result + (this.creditedAmount != null ? this.creditedAmount.hashCode() : 0);
        result = 31 * result + (this.purchasedAmount != null ? this.purchasedAmount.hashCode() : 0);
        result = 31 * result + (this.refundedAmount != null ? this.refundedAmount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.transactions != null ? this.transactions.hashCode() : 0);
        return result;
    }
}

