/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.joda.time.Period;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.util.config.PaymentConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverdueStateJson {
    private final String name;
    private final String externalMessage;
    private final List<Integer> daysBetweenPaymentRetries;
    private final Boolean disableEntitlementAndChangesBlocked;
    private final Boolean blockChanges;
    private final Boolean isClearState;
    private final Integer reevaluationIntervalDays;

    @JsonCreator
    public OverdueStateJson(@JsonProperty(value="name") String name, @JsonProperty(value="externalMessage") String externalMessage, @JsonProperty(value="daysBetweenPaymentRetries") List<Integer> daysBetweenPaymentRetries, @JsonProperty(value="disableEntitlementAndChangesBlocked") Boolean disableEntitlementAndChangesBlocked, @JsonProperty(value="blockChanges") Boolean blockChanges, @JsonProperty(value="clearState") Boolean isClearState, @JsonProperty(value="reevaluationIntervalDays") Integer reevaluationIntervalDays) {
        this.name = name;
        this.externalMessage = externalMessage;
        this.daysBetweenPaymentRetries = daysBetweenPaymentRetries;
        this.disableEntitlementAndChangesBlocked = disableEntitlementAndChangesBlocked;
        this.blockChanges = blockChanges;
        this.isClearState = isClearState;
        this.reevaluationIntervalDays = reevaluationIntervalDays;
    }

    public OverdueStateJson(OverdueState overdueState, PaymentConfig paymentConfig) {
        this.name = overdueState.getName();
        this.externalMessage = overdueState.getExternalMessage();
        this.daysBetweenPaymentRetries = paymentConfig.getPaymentFailureRetryDays();
        this.disableEntitlementAndChangesBlocked = overdueState.isDisableEntitlementAndChangesBlocked();
        this.blockChanges = overdueState.isBlockChanges();
        this.isClearState = overdueState.isClearState();
        Period reevaluationIntervalPeriod = null;
        try {
            reevaluationIntervalPeriod = overdueState.getAutoReevaluationInterval();
        }
        catch (OverdueApiException ignored) {
            // empty catch block
        }
        this.reevaluationIntervalDays = reevaluationIntervalPeriod != null ? Integer.valueOf(reevaluationIntervalPeriod.getDays()) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    public List<Integer> getDaysBetweenPaymentRetries() {
        return this.daysBetweenPaymentRetries;
    }

    public Boolean isDisableEntitlementAndChangesBlocked() {
        return this.disableEntitlementAndChangesBlocked;
    }

    public Boolean isBlockChanges() {
        return this.blockChanges;
    }

    public Boolean isClearState() {
        return this.isClearState;
    }

    public Integer getReevaluationIntervalDays() {
        return this.reevaluationIntervalDays;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OverdueStateJson");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", externalMessage='").append(this.externalMessage).append('\'');
        sb.append(", daysBetweenPaymentRetries=").append(this.daysBetweenPaymentRetries);
        sb.append(", disableEntitlementAndChangesBlocked=").append(this.disableEntitlementAndChangesBlocked);
        sb.append(", blockChanges=").append(this.blockChanges);
        sb.append(", isClearState=").append(this.isClearState);
        sb.append(", reevaluationIntervalDays=").append(this.reevaluationIntervalDays);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverdueStateJson that = (OverdueStateJson)o;
        if (this.blockChanges != null ? !this.blockChanges.equals(that.blockChanges) : that.blockChanges != null) {
            return false;
        }
        if (this.daysBetweenPaymentRetries != null ? !this.daysBetweenPaymentRetries.equals(that.daysBetweenPaymentRetries) : that.daysBetweenPaymentRetries != null) {
            return false;
        }
        if (this.disableEntitlementAndChangesBlocked != null ? !this.disableEntitlementAndChangesBlocked.equals(that.disableEntitlementAndChangesBlocked) : that.disableEntitlementAndChangesBlocked != null) {
            return false;
        }
        if (this.externalMessage != null ? !this.externalMessage.equals(that.externalMessage) : that.externalMessage != null) {
            return false;
        }
        if (this.isClearState != null ? !this.isClearState.equals(that.isClearState) : that.isClearState != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.reevaluationIntervalDays != null ? !this.reevaluationIntervalDays.equals(that.reevaluationIntervalDays) : that.reevaluationIntervalDays != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.externalMessage != null ? this.externalMessage.hashCode() : 0);
        result = 31 * result + (this.daysBetweenPaymentRetries != null ? this.daysBetweenPaymentRetries.hashCode() : 0);
        result = 31 * result + (this.disableEntitlementAndChangesBlocked != null ? this.disableEntitlementAndChangesBlocked.hashCode() : 0);
        result = 31 * result + (this.blockChanges != null ? this.blockChanges.hashCode() : 0);
        result = 31 * result + (this.isClearState != null ? this.isClearState.hashCode() : 0);
        result = 31 * result + (this.reevaluationIntervalDays != null ? this.reevaluationIntervalDays.hashCode() : 0);
        return result;
    }
}

