/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.CreditJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AuditLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceJson
extends JsonBase {
    private final BigDecimal amount;
    private final String currency;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String invoiceId;
    private final LocalDate invoiceDate;
    private final LocalDate targetDate;
    private final String invoiceNumber;
    private final BigDecimal balance;
    private final BigDecimal creditAdj;
    private final BigDecimal refundAdj;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String accountId;
    private final List<InvoiceItemJson> items;
    private final String bundleKeys;
    private final List<CreditJson> credits;

    @JsonCreator
    public InvoiceJson(@JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") String currency, @JsonProperty(value="creditAdj") BigDecimal creditAdj, @JsonProperty(value="refundAdj") BigDecimal refundAdj, @JsonProperty(value="invoiceId") String invoiceId, @JsonProperty(value="invoiceDate") LocalDate invoiceDate, @JsonProperty(value="targetDate") LocalDate targetDate, @JsonProperty(value="invoiceNumber") String invoiceNumber, @JsonProperty(value="balance") BigDecimal balance, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="externalBundleKeys") String bundleKeys, @JsonProperty(value="credits") List<CreditJson> credits, @JsonProperty(value="items") List<InvoiceItemJson> items, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.amount = amount;
        this.currency = currency;
        this.creditAdj = creditAdj;
        this.refundAdj = refundAdj;
        this.invoiceId = invoiceId;
        this.invoiceDate = invoiceDate;
        this.targetDate = targetDate;
        this.invoiceNumber = invoiceNumber;
        this.balance = balance;
        this.accountId = accountId;
        this.bundleKeys = bundleKeys;
        this.credits = credits;
        this.items = items;
    }

    public InvoiceJson(Invoice input) {
        this(input, false, null);
    }

    public InvoiceJson(Invoice input, String bundleKeys, List<CreditJson> credits, List<AuditLog> auditLogs) {
        this(input.getChargedAmount(), input.getCurrency().toString(), input.getCreditedAmount(), input.getRefundedAmount(), input.getId().toString(), input.getInvoiceDate(), input.getTargetDate(), String.valueOf(input.getInvoiceNumber()), input.getBalance(), input.getAccountId().toString(), bundleKeys, credits, null, (List<AuditLogJson>)InvoiceJson.toAuditLogJson(auditLogs));
    }

    public InvoiceJson(Invoice input, boolean withItems, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)InvoiceJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForInvoice(input.getId())));
        this.items = new ArrayList<InvoiceItemJson>(input.getInvoiceItems().size());
        if (withItems) {
            for (InvoiceItem item : input.getInvoiceItems()) {
                this.items.add(new InvoiceItemJson(item, accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForInvoiceItem(item.getId())));
            }
        }
        this.amount = input.getChargedAmount();
        this.currency = input.getCurrency().toString();
        this.creditAdj = input.getCreditedAmount();
        this.refundAdj = input.getRefundedAmount();
        this.invoiceId = input.getId().toString();
        this.invoiceDate = input.getInvoiceDate();
        this.targetDate = input.getTargetDate();
        this.invoiceNumber = input.getInvoiceNumber() == null ? null : String.valueOf(input.getInvoiceNumber());
        this.balance = input.getBalance();
        this.accountId = input.getAccountId().toString();
        this.bundleKeys = null;
        this.credits = null;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public BigDecimal getCreditAdj() {
        return this.creditAdj;
    }

    public BigDecimal getRefundAdj() {
        return this.refundAdj;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public List<InvoiceItemJson> getItems() {
        return this.items;
    }

    public String getBundleKeys() {
        return this.bundleKeys;
    }

    public List<CreditJson> getCredits() {
        return this.credits;
    }

    public String toString() {
        return "InvoiceJson{amount=" + this.amount + ", currency='" + this.currency + '\'' + ", invoiceId='" + this.invoiceId + '\'' + ", invoiceDate=" + this.invoiceDate + ", targetDate=" + this.targetDate + ", invoiceNumber='" + this.invoiceNumber + '\'' + ", balance=" + this.balance + ", creditAdj=" + this.creditAdj + ", refundAdj=" + this.refundAdj + ", accountId='" + this.accountId + '\'' + ", items=" + this.items + ", bundleKeys='" + this.bundleKeys + '\'' + ", credits=" + this.credits + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceJson that = (InvoiceJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.balance != null ? this.balance.compareTo(that.balance) != 0 : that.balance != null) {
            return false;
        }
        if (this.bundleKeys != null ? !this.bundleKeys.equals(that.bundleKeys) : that.bundleKeys != null) {
            return false;
        }
        if (this.creditAdj != null ? this.creditAdj.compareTo(that.creditAdj) != 0 : that.creditAdj != null) {
            return false;
        }
        if (this.credits != null ? !this.credits.equals(that.credits) : that.credits != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.invoiceDate != null ? this.invoiceDate.compareTo((ReadablePartial)that.invoiceDate) != 0 : that.invoiceDate != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.invoiceNumber != null ? !this.invoiceNumber.equals(that.invoiceNumber) : that.invoiceNumber != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.refundAdj != null ? this.refundAdj.compareTo(that.refundAdj) != 0 : that.refundAdj != null) {
            return false;
        }
        return !(this.targetDate != null ? this.targetDate.compareTo((ReadablePartial)that.targetDate) != 0 : that.targetDate != null);
    }

    public int hashCode() {
        int result = this.amount != null ? this.amount.hashCode() : 0;
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.invoiceDate != null ? this.invoiceDate.hashCode() : 0);
        result = 31 * result + (this.targetDate != null ? this.targetDate.hashCode() : 0);
        result = 31 * result + (this.invoiceNumber != null ? this.invoiceNumber.hashCode() : 0);
        result = 31 * result + (this.balance != null ? this.balance.hashCode() : 0);
        result = 31 * result + (this.creditAdj != null ? this.creditAdj.hashCode() : 0);
        result = 31 * result + (this.refundAdj != null ? this.refundAdj.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.bundleKeys != null ? this.bundleKeys.hashCode() : 0);
        result = 31 * result + (this.credits != null ? this.credits.hashCode() : 0);
        return result;
    }
}

