/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AuditLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceItemJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID", required=true)
    private final String invoiceItemId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String invoiceId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String linkedInvoiceItemId;
    @ApiModelProperty(dataType="java.util.UUID", required=true)
    private final String accountId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String bundleId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String subscriptionId;
    private final String planName;
    private final String phaseName;
    private final String usageName;
    private final String itemType;
    private final String description;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final BigDecimal amount;
    private final Currency currency;

    @JsonCreator
    public InvoiceItemJson(@JsonProperty(value="invoiceItemId") String invoiceItemId, @JsonProperty(value="invoiceId") String invoiceId, @JsonProperty(value="linkedInvoiceItemId") String linkedInvoiceItemId, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="bundleId") String bundleId, @JsonProperty(value="subscriptionId") String subscriptionId, @JsonProperty(value="planName") String planName, @JsonProperty(value="phaseName") String phaseName, @JsonProperty(value="usageName") String usageName, @JsonProperty(value="itemType") String itemType, @JsonProperty(value="description") String description, @JsonProperty(value="startDate") LocalDate startDate, @JsonProperty(value="endDate") LocalDate endDate, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.invoiceItemId = invoiceItemId;
        this.invoiceId = invoiceId;
        this.linkedInvoiceItemId = linkedInvoiceItemId;
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.subscriptionId = subscriptionId;
        this.planName = planName;
        this.phaseName = phaseName;
        this.usageName = usageName;
        this.itemType = itemType;
        this.description = description;
        this.startDate = startDate;
        this.endDate = endDate;
        this.amount = amount;
        this.currency = currency;
    }

    public InvoiceItemJson(InvoiceItem item, @Nullable List<AuditLog> auditLogs) {
        this(InvoiceItemJson.toString(item.getId()), InvoiceItemJson.toString(item.getInvoiceId()), InvoiceItemJson.toString(item.getLinkedItemId()), InvoiceItemJson.toString(item.getAccountId()), InvoiceItemJson.toString(item.getBundleId()), InvoiceItemJson.toString(item.getSubscriptionId()), item.getPlanName(), item.getPhaseName(), item.getUsageName(), item.getInvoiceItemType().toString(), item.getDescription(), item.getStartDate(), item.getEndDate(), item.getAmount(), item.getCurrency(), (List<AuditLogJson>)InvoiceItemJson.toAuditLogJson(auditLogs));
    }

    public InvoiceItem toInvoiceItem() {
        return new InvoiceItem(){

            public InvoiceItemType getInvoiceItemType() {
                return InvoiceItemJson.this.itemType != null ? InvoiceItemType.valueOf((String)InvoiceItemJson.this.itemType) : null;
            }

            public UUID getInvoiceId() {
                return InvoiceItemJson.this.invoiceId != null ? UUID.fromString(InvoiceItemJson.this.invoiceId) : null;
            }

            public UUID getAccountId() {
                return InvoiceItemJson.this.accountId != null ? UUID.fromString(InvoiceItemJson.this.accountId) : null;
            }

            public LocalDate getStartDate() {
                return InvoiceItemJson.this.startDate;
            }

            public LocalDate getEndDate() {
                return InvoiceItemJson.this.endDate;
            }

            public BigDecimal getAmount() {
                return InvoiceItemJson.this.amount;
            }

            public Currency getCurrency() {
                return InvoiceItemJson.this.currency;
            }

            public String getDescription() {
                return InvoiceItemJson.this.description;
            }

            public UUID getBundleId() {
                return InvoiceItemJson.this.bundleId != null ? UUID.fromString(InvoiceItemJson.this.bundleId) : null;
            }

            public UUID getSubscriptionId() {
                return InvoiceItemJson.this.subscriptionId != null ? UUID.fromString(InvoiceItemJson.this.subscriptionId) : null;
            }

            public String getPlanName() {
                return InvoiceItemJson.this.planName;
            }

            public String getPhaseName() {
                return InvoiceItemJson.this.phaseName;
            }

            public String getUsageName() {
                return InvoiceItemJson.this.usageName;
            }

            public BigDecimal getRate() {
                return null;
            }

            public UUID getLinkedItemId() {
                return InvoiceItemJson.this.linkedInvoiceItemId != null ? UUID.fromString(InvoiceItemJson.this.linkedInvoiceItemId) : null;
            }

            public boolean matches(Object o) {
                return false;
            }

            public UUID getId() {
                return null;
            }

            public DateTime getCreatedDate() {
                return null;
            }

            public DateTime getUpdatedDate() {
                return null;
            }
        };
    }

    public InvoiceItemJson(InvoiceItem input) {
        this(input, null);
    }

    public String getInvoiceItemId() {
        return this.invoiceItemId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getLinkedInvoiceItemId() {
        return this.linkedInvoiceItemId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getUsageName() {
        return this.usageName;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InvoiceItemJson");
        sb.append("{invoiceItemId='").append(this.invoiceItemId).append('\'');
        sb.append(", invoiceId='").append(this.invoiceId).append('\'');
        sb.append(", linkedInvoiceItemId='").append(this.linkedInvoiceItemId).append('\'');
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append(", bundleId='").append(this.bundleId).append('\'');
        sb.append(", subscriptionId='").append(this.subscriptionId).append('\'');
        sb.append(", planName='").append(this.planName).append('\'');
        sb.append(", phaseName='").append(this.phaseName).append('\'');
        sb.append(", usageName='").append(this.usageName).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", startDate=").append(this.startDate);
        sb.append(", endDate=").append(this.endDate);
        sb.append(", amount=").append(this.amount);
        sb.append(", currency=").append(this.currency);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceItemJson that = (InvoiceItemJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (!(this.amount == null && that.amount == null || this.amount != null && that.amount != null && this.amount.compareTo(that.amount) == 0)) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!(this.endDate == null && that.endDate == null || this.endDate != null && that.endDate != null && this.endDate.compareTo((ReadablePartial)that.endDate) == 0)) {
            return false;
        }
        if (this.invoiceItemId != null ? !this.invoiceItemId.equals(that.invoiceItemId) : that.invoiceItemId != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.linkedInvoiceItemId != null ? !this.linkedInvoiceItemId.equals(that.linkedInvoiceItemId) : that.linkedInvoiceItemId != null) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.usageName != null ? !this.usageName.equals(that.usageName) : that.usageName != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (!(this.startDate == null && that.startDate == null || this.startDate != null && that.startDate != null && this.startDate.compareTo((ReadablePartial)that.startDate) == 0)) {
            return false;
        }
        return !(this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null);
    }

    public int hashCode() {
        int result = this.invoiceId != null ? this.invoiceId.hashCode() : 0;
        result = 31 * result + (this.invoiceItemId != null ? this.invoiceItemId.hashCode() : 0);
        result = 31 * result + (this.linkedInvoiceItemId != null ? this.linkedInvoiceItemId.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.phaseName != null ? this.phaseName.hashCode() : 0);
        result = 31 * result + (this.usageName != null ? this.usageName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        return result;
    }
}

