/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.StaticCatalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogJsonSimple {
    private final String name;
    private final List<ProductJson> products;

    @JsonCreator
    public CatalogJsonSimple(@JsonProperty(value="name") String name, @JsonProperty(value="products") List<ProductJson> products) {
        this.name = name;
        this.products = products;
    }

    public CatalogJsonSimple(StaticCatalog catalog) throws CatalogApiException {
        this.name = catalog.getCatalogName();
        Plan[] plans = catalog.getCurrentPlans();
        HashMap<String, ProductJson> productMap = new HashMap<String, ProductJson>();
        for (Plan plan : plans) {
            Product product = plan.getProduct();
            ProductJson productJson = (ProductJson)productMap.get(product.getName());
            if (productJson == null) {
                productJson = new ProductJson(product.getCategory().toString(), product.getName(), this.toProductNames(product.getIncluded()), this.toProductNames(product.getAvailable()));
                productMap.put(product.getName(), productJson);
            }
            LinkedList<PhaseJson> phases = new LinkedList<PhaseJson>();
            for (PlanPhase phase : plan.getAllPhases()) {
                LinkedList<PriceJson> prices = new LinkedList<PriceJson>();
                if (phase.getRecurring() != null && phase.getRecurring().getRecurringPrice() != null) {
                    for (Price price : phase.getRecurring().getRecurringPrice().getPrices()) {
                        prices.add(new PriceJson(price));
                    }
                }
                PhaseJson phaseJson = new PhaseJson(phase.getPhaseType().toString(), prices);
                phases.add(phaseJson);
            }
            PlanJson planJson = new PlanJson(plan.getName(), phases);
            productJson.getPlans().add(planJson);
        }
        this.products = ImmutableList.copyOf(productMap.values());
    }

    private List<String> toProductNames(Product[] in) {
        return Lists.transform((List)ImmutableList.copyOf((Object[])in), (Function)new Function<Product, String>(){

            public String apply(Product input) {
                return input.getName();
            }
        });
    }

    public List<ProductJson> getProducts() {
        return this.products;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CatalogJsonSimple{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", products=").append(this.products);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogJsonSimple that = (CatalogJsonSimple)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.products != null ? !this.products.equals(that.products) : that.products != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.products != null ? this.products.hashCode() : 0);
        return result;
    }

    public static class PriceJson {
        private final String currency;
        private final BigDecimal value;

        @JsonCreator
        public PriceJson(@JsonProperty(value="currency") String currency, @JsonProperty(value="value") BigDecimal value) {
            this.currency = currency;
            this.value = value;
        }

        public PriceJson(Price price) throws CurrencyValueNull {
            this(price.getCurrency().toString(), price.getValue());
        }

        public String getCurrency() {
            return this.currency;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PriceJson{");
            sb.append("currency='").append(this.currency).append('\'');
            sb.append(", value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PriceJson priceJson = (PriceJson)o;
            if (this.currency != null ? !this.currency.equals(priceJson.currency) : priceJson.currency != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(priceJson.value) : priceJson.value != null);
        }

        public int hashCode() {
            int result = this.currency != null ? this.currency.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhaseJson {
        private final String type;
        private final List<PriceJson> prices;

        @JsonCreator
        public PhaseJson(@JsonProperty(value="type") String type, @JsonProperty(value="prices") List<PriceJson> prices) {
            this.type = type;
            this.prices = prices;
        }

        public String getType() {
            return this.type;
        }

        public List<PriceJson> getPrices() {
            return this.prices;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PhaseJson{");
            sb.append("type='").append(this.type).append('\'');
            sb.append(", prices=").append(this.prices);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhaseJson phaseJson = (PhaseJson)o;
            if (this.prices != null ? !this.prices.equals(phaseJson.prices) : phaseJson.prices != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(phaseJson.type) : phaseJson.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.prices != null ? this.prices.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlanJson {
        private final String name;
        private final List<PhaseJson> phases;

        @JsonCreator
        public PlanJson(@JsonProperty(value="name") String name, @JsonProperty(value="phases") List<PhaseJson> phases) {
            this.name = name;
            this.phases = phases;
        }

        public String getName() {
            return this.name;
        }

        public List<PhaseJson> getPhases() {
            return this.phases;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlanJson{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", phases=").append(this.phases);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlanJson planJson = (PlanJson)o;
            if (this.name != null ? !this.name.equals(planJson.name) : planJson.name != null) {
                return false;
            }
            return !(this.phases != null ? !this.phases.equals(planJson.phases) : planJson.phases != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.phases != null ? this.phases.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProductJson {
        private final String type;
        private final String name;
        private final List<PlanJson> plans;
        private final List<String> included;
        private final List<String> available;

        @JsonCreator
        public ProductJson(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="plans") List<PlanJson> plans, @JsonProperty(value="included") List<String> included, @JsonProperty(value="available") List<String> available) {
            this.type = type;
            this.name = name;
            this.plans = plans;
            this.included = included;
            this.available = available;
        }

        public ProductJson(String type, String name, List<String> included, List<String> available) {
            this(type, name, new LinkedList<PlanJson>(), included, available);
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public List<PlanJson> getPlans() {
            return this.plans;
        }

        public List<String> getIncluded() {
            return this.included;
        }

        public List<String> getAvailable() {
            return this.available;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProductJson{");
            sb.append("type='").append(this.type).append('\'');
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", plans=").append(this.plans);
            sb.append(", included=").append(this.included);
            sb.append(", available=").append(this.available);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProductJson that = (ProductJson)o;
            if (this.available != null ? !this.available.equals(that.available) : that.available != null) {
                return false;
            }
            if (this.included != null ? !this.included.equals(that.included) : that.included != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.plans != null ? !this.plans.equals(that.plans) : that.plans != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.plans != null ? this.plans.hashCode() : 0);
            result = 31 * result + (this.included != null ? this.included.hashCode() : 0);
            result = 31 * result + (this.available != null ? this.available.hashCode() : 0);
            return result;
        }
    }
}

