/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BundleTimelineJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID", required=true)
    private final String accountId;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String bundleId;
    private final String externalKey;
    private final List<SubscriptionJson> subscriptions;
    private final BundleTimelineJson timeline;

    @JsonCreator
    public BundleJson(@JsonProperty(value="accountId") @Nullable String accountId, @JsonProperty(value="bundleId") @Nullable String bundleId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="subscriptions") @Nullable List<SubscriptionJson> subscriptions, @JsonProperty(value="timeline") @Nullable BundleTimelineJson timeline, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.externalKey = externalKey;
        this.subscriptions = subscriptions;
        this.timeline = timeline;
    }

    public BundleJson(SubscriptionBundle bundle, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)BundleJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForBundle(bundle.getId())));
        this.accountId = bundle.getAccountId().toString();
        this.bundleId = bundle.getId().toString();
        this.externalKey = bundle.getExternalKey();
        this.subscriptions = new LinkedList<SubscriptionJson>();
        for (Subscription subscription : bundle.getSubscriptions()) {
            this.subscriptions.add(new SubscriptionJson(subscription, accountAuditLogs));
        }
        this.timeline = new BundleTimelineJson(bundle.getTimeline(), accountAuditLogs);
    }

    public List<SubscriptionJson> getSubscriptions() {
        return this.subscriptions;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public BundleTimelineJson getTimeline() {
        return this.timeline;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BundleJson{");
        sb.append("accountId='").append(this.accountId).append('\'');
        sb.append(", bundleId='").append(this.bundleId).append('\'');
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", subscriptions=").append(this.subscriptions);
        sb.append(", timeline=").append(this.timeline);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleJson that = (BundleJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.subscriptions != null ? !this.subscriptions.equals(that.subscriptions) : that.subscriptions != null) {
            return false;
        }
        return !(this.timeline != null ? !this.timeline.equals(that.timeline) : that.timeline != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.subscriptions != null ? this.subscriptions.hashCode() : 0);
        result = 31 * result + (this.timeline != null ? this.timeline.hashCode() : 0);
        return result;
    }
}

