/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingStateJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID")
    private final String blockedId;
    private final String stateName;
    private final String service;
    private final Boolean blockChange;
    private final Boolean blockEntitlement;
    private final Boolean blockBilling;
    private final LocalDate effectiveDate;
    private final BlockingStateType type;

    @JsonCreator
    public BlockingStateJson(@JsonProperty(value="blockedId") String blockedId, @JsonProperty(value="stateName") String stateName, @JsonProperty(value="service") String service, @JsonProperty(value="blockChange") Boolean blockChange, @JsonProperty(value="blockEntitlement") Boolean blockEntitlement, @JsonProperty(value="blockBilling") Boolean blockBilling, @JsonProperty(value="effectiveDate") LocalDate effectiveDate, @JsonProperty(value="type") BlockingStateType type, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.blockedId = blockedId;
        this.stateName = stateName;
        this.service = service;
        this.blockChange = blockChange;
        this.blockEntitlement = blockEntitlement;
        this.blockBilling = blockBilling;
        this.effectiveDate = effectiveDate;
        this.type = type;
    }

    public String getBlockedId() {
        return this.blockedId;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getService() {
        return this.service;
    }

    public Boolean isBlockChange() {
        return this.blockChange;
    }

    public Boolean isBlockEntitlement() {
        return this.blockEntitlement;
    }

    public Boolean isBlockBilling() {
        return this.blockBilling;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public BlockingStateType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockingStateJson)) {
            return false;
        }
        BlockingStateJson that = (BlockingStateJson)o;
        if (this.blockChange != that.blockChange) {
            return false;
        }
        if (this.blockEntitlement != that.blockEntitlement) {
            return false;
        }
        if (this.blockBilling != that.blockBilling) {
            return false;
        }
        if (this.blockedId != null ? !this.blockedId.equals(that.blockedId) : that.blockedId != null) {
            return false;
        }
        if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadablePartial)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.blockedId != null ? this.blockedId.hashCode() : 0;
        result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.blockChange != false ? 1 : 0);
        result = 31 * result + (this.blockEntitlement != false ? 1 : 0);
        result = 31 * result + (this.blockBilling != false ? 1 : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BlockingStateJson{blockedId='" + this.blockedId + '\'' + ", stateName='" + this.stateName + '\'' + ", service='" + this.service + '\'' + ", blockChange=" + this.blockChange + ", blockEntitlement=" + this.blockEntitlement + ", blockBilling=" + this.blockBilling + ", effectiveDate=" + this.effectiveDate + ", type=" + this.type + '}';
    }
}

