/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountJson
extends JsonBase {
    @ApiModelProperty(dataType="java.util.UUID")
    private final String accountId;
    private final String externalKey;
    private final BigDecimal accountCBA;
    private final BigDecimal accountBalance;
    private final String name;
    private final Integer firstNameLength;
    private final String email;
    private final Integer billCycleDayLocal;
    private final String currency;
    @ApiModelProperty(dataType="java.util.UUID")
    private final String paymentMethodId;
    private final String timeZone;
    private final String address1;
    private final String address2;
    private final String postalCode;
    private final String company;
    private final String city;
    private final String state;
    private final String country;
    private final String locale;
    private final String phone;
    private final Boolean isMigrated;
    private final Boolean isNotifiedForInvoices;

    public AccountJson(Account account, BigDecimal accountBalance, BigDecimal accountCBA, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)AccountJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForAccount()));
        this.accountCBA = accountCBA;
        this.accountBalance = accountBalance;
        this.accountId = account.getId().toString();
        this.externalKey = account.getExternalKey();
        this.name = account.getName();
        this.firstNameLength = account.getFirstNameLength();
        this.email = account.getEmail();
        this.billCycleDayLocal = account.getBillCycleDayLocal();
        this.currency = account.getCurrency() != null ? account.getCurrency().toString() : null;
        this.paymentMethodId = account.getPaymentMethodId() != null ? account.getPaymentMethodId().toString() : null;
        this.timeZone = account.getTimeZone() != null ? account.getTimeZone().toString() : null;
        this.address1 = account.getAddress1();
        this.address2 = account.getAddress2();
        this.postalCode = account.getPostalCode();
        this.company = account.getCompanyName();
        this.city = account.getCity();
        this.state = account.getStateOrProvince();
        this.country = account.getCountry();
        this.locale = account.getLocale();
        this.phone = account.getPhone();
        this.isMigrated = account.isMigrated();
        this.isNotifiedForInvoices = account.isNotifiedForInvoices();
    }

    @JsonCreator
    public AccountJson(@JsonProperty(value="accountId") String accountId, @JsonProperty(value="name") String name, @JsonProperty(value="firstNameLength") Integer firstNameLength, @JsonProperty(value="externalKey") String externalKey, @JsonProperty(value="email") String email, @JsonProperty(value="billCycleDayLocal") Integer billCycleDayLocal, @JsonProperty(value="currency") String currency, @JsonProperty(value="paymentMethodId") String paymentMethodId, @JsonProperty(value="timeZone") String timeZone, @JsonProperty(value="address1") String address1, @JsonProperty(value="address2") String address2, @JsonProperty(value="postalCode") String postalCode, @JsonProperty(value="company") String company, @JsonProperty(value="city") String city, @JsonProperty(value="state") String state, @JsonProperty(value="country") String country, @JsonProperty(value="locale") String locale, @JsonProperty(value="phone") String phone, @JsonProperty(value="isMigrated") Boolean isMigrated, @JsonProperty(value="isNotifiedForInvoices") Boolean isNotifiedForInvoices, @JsonProperty(value="accountBalance") BigDecimal accountBalance, @JsonProperty(value="accountCBA") BigDecimal accountCBA, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.accountBalance = accountBalance;
        this.externalKey = externalKey;
        this.accountId = accountId;
        this.name = name;
        this.firstNameLength = firstNameLength;
        this.email = email;
        this.billCycleDayLocal = billCycleDayLocal;
        this.currency = currency;
        this.paymentMethodId = paymentMethodId;
        this.timeZone = timeZone;
        this.address1 = address1;
        this.address2 = address2;
        this.postalCode = postalCode;
        this.company = company;
        this.city = city;
        this.state = state;
        this.country = country;
        this.locale = locale;
        this.phone = phone;
        this.isMigrated = isMigrated;
        this.isNotifiedForInvoices = isNotifiedForInvoices;
        this.accountCBA = accountCBA;
    }

    public AccountData toAccountData() {
        return new AccountData(){

            public DateTimeZone getTimeZone() {
                if (Strings.emptyToNull((String)AccountJson.this.timeZone) == null) {
                    return null;
                }
                return DateTimeZone.forID((String)AccountJson.this.timeZone);
            }

            public String getStateOrProvince() {
                return AccountJson.this.state;
            }

            public String getPostalCode() {
                return AccountJson.this.postalCode;
            }

            public String getPhone() {
                return AccountJson.this.phone;
            }

            public Boolean isMigrated() {
                return AccountJson.this.isMigrated;
            }

            public Boolean isNotifiedForInvoices() {
                return AccountJson.this.isNotifiedForInvoices;
            }

            public UUID getPaymentMethodId() {
                if (Strings.emptyToNull((String)AccountJson.this.paymentMethodId) == null) {
                    return null;
                }
                return UUID.fromString(AccountJson.this.paymentMethodId);
            }

            public String getName() {
                return AccountJson.this.name;
            }

            public String getLocale() {
                return AccountJson.this.locale;
            }

            public Integer getFirstNameLength() {
                return AccountJson.this.firstNameLength;
            }

            public String getExternalKey() {
                return AccountJson.this.externalKey;
            }

            public String getEmail() {
                return AccountJson.this.email;
            }

            public Currency getCurrency() {
                if (Strings.emptyToNull((String)AccountJson.this.currency) == null) {
                    return null;
                }
                return Currency.valueOf((String)AccountJson.this.currency);
            }

            public String getCountry() {
                return AccountJson.this.country;
            }

            public String getCompanyName() {
                return AccountJson.this.company;
            }

            public String getCity() {
                return AccountJson.this.city;
            }

            public Integer getBillCycleDayLocal() {
                return AccountJson.this.billCycleDayLocal;
            }

            public String getAddress2() {
                return AccountJson.this.address2;
            }

            public String getAddress1() {
                return AccountJson.this.address1;
            }
        };
    }

    public BigDecimal getAccountBalance() {
        return this.accountBalance;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public BigDecimal getAccountCBA() {
        return this.accountCBA;
    }

    public String getName() {
        return this.name;
    }

    public Integer getFirstNameLength() {
        return this.firstNameLength;
    }

    public String getEmail() {
        return this.email;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getPhone() {
        return this.phone;
    }

    @JsonProperty(value="isMigrated")
    public Boolean isMigrated() {
        return this.isMigrated;
    }

    @JsonProperty(value="isNotifiedForInvoices")
    public Boolean isNotifiedForInvoices() {
        return this.isNotifiedForInvoices;
    }

    public String toString() {
        return "AccountJson{accountId='" + this.accountId + '\'' + ", externalKey='" + this.externalKey + '\'' + ", accountCBA=" + this.accountCBA + ", accountBalance=" + this.accountBalance + ", name='" + this.name + '\'' + ", firstNameLength=" + this.firstNameLength + ", email='" + this.email + '\'' + ", billCycleDayLocal=" + this.billCycleDayLocal + ", currency='" + this.currency + '\'' + ", paymentMethodId='" + this.paymentMethodId + '\'' + ", timeZone='" + this.timeZone + '\'' + ", address1='" + this.address1 + '\'' + ", address2='" + this.address2 + '\'' + ", postalCode='" + this.postalCode + '\'' + ", company='" + this.company + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", country='" + this.country + '\'' + ", locale='" + this.locale + '\'' + ", phone='" + this.phone + '\'' + ", isMigrated=" + this.isMigrated + ", isNotifiedForInvoices=" + this.isNotifiedForInvoices + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountJson that = (AccountJson)o;
        if (this.accountBalance != null ? this.accountBalance.compareTo(that.accountBalance) != 0 : that.accountBalance != null) {
            return false;
        }
        if (this.accountCBA != null ? this.accountCBA.compareTo(that.accountCBA) != 0 : that.accountCBA != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) {
            return false;
        }
        if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) {
            return false;
        }
        if (this.billCycleDayLocal != null ? !this.billCycleDayLocal.equals(that.billCycleDayLocal) : that.billCycleDayLocal != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
            return false;
        }
        if (this.company != null ? !this.company.equals(that.company) : that.company != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.firstNameLength != null ? !this.firstNameLength.equals(that.firstNameLength) : that.firstNameLength != null) {
            return false;
        }
        if (this.isMigrated != null ? !this.isMigrated.equals(that.isMigrated) : that.isMigrated != null) {
            return false;
        }
        if (this.isNotifiedForInvoices != null ? !this.isNotifiedForInvoices.equals(that.isNotifiedForInvoices) : that.isNotifiedForInvoices != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        return !(this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.accountCBA != null ? this.accountCBA.hashCode() : 0);
        result = 31 * result + (this.accountBalance != null ? this.accountBalance.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.firstNameLength != null ? this.firstNameLength.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.billCycleDayLocal != null ? this.billCycleDayLocal.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
        result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.company != null ? this.company.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.isMigrated != null ? this.isMigrated.hashCode() : 0);
        result = 31 * result + (this.isNotifiedForInvoices != null ? this.isNotifiedForInvoices.hashCode() : 0);
        return result;
    }
}

