/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.killbill.billing.util.config.JaxrsConfig;
import org.killbill.commons.concurrent.WithProfilingThreadPoolExecutor;

public class JaxrsExecutors {
    private static final long TIMEOUT_EXECUTOR_SEC = 3L;
    private static final String JAXRS_THREAD_PREFIX = "jaxrs-th-";
    private static final String JAXRS_TH_GROUP_NAME = "jaxrs-grp";
    private final JaxrsConfig JaxrsConfig;
    private volatile ExecutorService jaxrsExecutorService;

    @Inject
    public JaxrsExecutors(JaxrsConfig JaxrsConfig2) {
        this.JaxrsConfig = JaxrsConfig2;
    }

    public void initialize() {
        this.jaxrsExecutorService = this.createJaxrsExecutorService();
    }

    public void stop() throws InterruptedException {
        this.jaxrsExecutorService.shutdownNow();
        this.jaxrsExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
        this.jaxrsExecutorService = null;
    }

    public ExecutorService getJaxrsExecutorService() {
        return this.jaxrsExecutorService;
    }

    private ExecutorService createJaxrsExecutorService() {
        return new WithProfilingThreadPoolExecutor(this.JaxrsConfig.getJaxrsThreadNb(), this.JaxrsConfig.getJaxrsThreadNb(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread th = new Thread(new ThreadGroup(JaxrsExecutors.JAXRS_TH_GROUP_NAME), r);
                th.setName(JaxrsExecutors.JAXRS_THREAD_PREFIX + th.getId());
                return th;
            }
        });
    }
}

