/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs;

import javax.inject.Inject;
import org.killbill.billing.jaxrs.JaxrsExecutors;
import org.killbill.billing.jaxrs.JaxrsService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJaxrsService
implements JaxrsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultJaxrsService.class);
    private static final String JAXRS_SERVICE_NAME = "jaxrs-service";
    private final JaxrsExecutors jaxrsExecutors;

    @Inject
    public DefaultJaxrsService(JaxrsExecutors jaxrsExecutors) {
        this.jaxrsExecutors = jaxrsExecutors;
    }

    public String getName() {
        return JAXRS_SERVICE_NAME;
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
    public void initialize() throws NotificationQueueService.NotificationQueueAlreadyExists {
        this.jaxrsExecutors.initialize();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_SERVICE)
    public void stop() throws NotificationQueueService.NoSuchNotificationQueue {
        try {
            this.jaxrsExecutors.stop();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("JaxrsService got interrupted", (Throwable)e);
        }
    }
}

