/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.collect.ImmutableList;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.payment.api.PluginProperty;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJaxRsResourceBase
extends JaxrsTestSuiteNoDB {
    private final JaxRsResourceBaseTest base = new JaxRsResourceBaseTest();

    @Test(groups={"fast"})
    public void testExtractPluginProperties() throws Exception {
        ImmutableList pluginPropertiesString = ImmutableList.of((Object)"payment_cryptogram=EHuWW9PiBkWvqE5juRwDzAUFBAk=", (Object)"cc_number=4111111111111111", (Object)"cc_type=visa", (Object)"cc_expiration_month=09", (Object)"cc_expiration_year=2020");
        ImmutableList pluginProperties = ImmutableList.copyOf((Iterable)this.base.extractPluginProperties((Iterable)pluginPropertiesString, new PluginProperty[0]));
        Assert.assertEquals((int)pluginProperties.size(), (int)5);
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(0)).getKey(), (String)"payment_cryptogram");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(0)).getValue(), (Object)"EHuWW9PiBkWvqE5juRwDzAUFBAk=");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(1)).getKey(), (String)"cc_number");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(1)).getValue(), (Object)"4111111111111111");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(2)).getKey(), (String)"cc_type");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(2)).getValue(), (Object)"visa");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(3)).getKey(), (String)"cc_expiration_month");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(3)).getValue(), (Object)"09");
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(4)).getKey(), (String)"cc_expiration_year");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(4)).getValue(), (Object)"2020");
    }

    @Test(groups={"fast"})
    public void testExtractPluginPropertiesWithNullProperty() throws Exception {
        ImmutableList pluginPropertiesString = ImmutableList.of((Object)"foo=", (Object)"bar=ttt");
        ImmutableList pluginProperties = ImmutableList.copyOf((Iterable)this.base.extractPluginProperties((Iterable)pluginPropertiesString, new PluginProperty[0]));
        Assert.assertEquals((int)pluginProperties.size(), (int)1);
        Assert.assertEquals((String)((PluginProperty)pluginProperties.get(0)).getKey(), (String)"bar");
        Assert.assertEquals((Object)((PluginProperty)pluginProperties.get(0)).getValue(), (Object)"ttt");
    }

    private static final class JaxRsResourceBaseTest
    extends JaxRsResourceBase {
        public JaxRsResourceBaseTest() {
            super(null, null, null, null, null, null, null, null);
        }
    }
}

