/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.util.UUIDs;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDateConversion
extends JaxRsResourceBase {
    public TestDateConversion() throws AccountApiException {
        super(null, null, null, null, (AccountUserApi)Mockito.mock(AccountUserApi.class), null, (Clock)new ClockMock(), null);
    }

    public UUID setupAccount(DateTimeZone accountTimeZone) throws AccountApiException {
        UUID accountId = UUIDs.randomUUID();
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)accountTimeZone);
        Mockito.when((Object)this.accountUserApi.getAccountById(accountId, null)).thenReturn((Object)account);
        return accountId;
    }

    @BeforeTest(groups={"fast"})
    public void beforeTest() {
        ((ClockMock)this.clock).resetDeltaFromReality();
    }

    @Test(groups={"fast"})
    public void testDateTimeConversion() throws AccountApiException {
        UUID accountId = this.setupAccount(DateTimeZone.forOffsetHours((int)-8));
        String input = "2013-08-26T06:50:20Z";
        LocalDate result = this.toLocalDate(accountId, "2013-08-26T06:50:20Z", null);
        Assert.assertTrue((result.compareTo((ReadablePartial)new LocalDate(2013, 8, 25)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testNullConversion() throws AccountApiException {
        UUID accountId = this.setupAccount(DateTimeZone.forOffsetHours((int)-8));
        ((ClockMock)this.clock).setTime(new DateTime((Object)"2013-08-26T06:50:20Z"));
        String input = null;
        LocalDate result = this.toLocalDate(accountId, input, null);
        Assert.assertTrue((result.compareTo((ReadablePartial)new LocalDate(2013, 8, 25)) == 0 ? 1 : 0) != 0);
        ((ClockMock)this.clock).resetDeltaFromReality();
    }

    @Test(groups={"fast"})
    public void testLocalDateConversion() throws AccountApiException {
        UUID accountId = this.setupAccount(DateTimeZone.forOffsetHours((int)-8));
        String input = "2013-08-25";
        LocalDate result = this.toLocalDate(accountId, "2013-08-25", null);
        Assert.assertTrue((result.compareTo((ReadablePartial)new LocalDate(2013, 8, 25)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testTwoLocalDatesWithDifferentTimeZonesAreEquals() throws AccountApiException {
        String inputDate = "2013-08-25";
        LocalDate localDate = LocalDate.parse((String)"2013-08-25", (DateTimeFormatter)this.LOCAL_DATE_FORMATTER);
        LocalDate localDateInUTC = new LocalDate((Object)localDate, DateTimeZone.UTC);
        LocalDate localDateInAccountTimeZone = new LocalDate((Object)localDate, DateTimeZone.forOffsetHours((int)-8));
        Assert.assertEquals((Object)localDateInUTC, (Object)localDateInAccountTimeZone);
    }

    @Test(groups={"fast"})
    public void testTwoDateTimesConstructedFromDateTimesWithDifferentTimeZonesAreDifferent() throws AccountApiException {
        DateTime nowUTC = this.DATE_TIME_FORMATTER.parseDateTime("2015-04-05T05:27:17.547Z");
        LocalDate localDateInUTC = new LocalDate((Object)nowUTC, DateTimeZone.UTC);
        LocalDate localDateInAccountTimeZone = new LocalDate((Object)nowUTC, DateTimeZone.forOffsetHours((int)-8));
        Assert.assertNotEquals((Object)localDateInUTC, (Object)localDateInAccountTimeZone);
    }
}

