/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDateConversion
extends JaxRsResourceBase {
    final UUID accountId = UUID.fromString("ffa649da-555e-4c55-bf65-84b06a4b3564");
    final DateTimeZone dateTimeZone = DateTimeZone.forOffsetHours((int)-8);

    public TestDateConversion() throws AccountApiException {
        super(null, null, null, null, (AccountUserApi)Mockito.mock(AccountUserApi.class), null, (Clock)new ClockMock(), null);
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)this.dateTimeZone);
        Mockito.when((Object)this.accountUserApi.getAccountById(this.accountId, null)).thenReturn((Object)account);
    }

    @BeforeClass
    public void beforeClass() {
    }

    @Test(groups={"fast"})
    public void testDateTimeConversion() {
        String input = "2013-08-26T06:50:20Z";
        LocalDate result = this.toLocalDate(this.accountId, "2013-08-26T06:50:20Z", null);
        Assert.assertTrue((result.compareTo((ReadablePartial)new LocalDate(2013, 8, 25)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testNullConversion() {
        ((ClockMock)this.clock).setTime(new DateTime((Object)"2013-08-26T06:50:20Z"));
        String input = null;
        LocalDate result = this.toLocalDate(this.accountId, input, null);
        Assert.assertTrue((result.compareTo((ReadablePartial)new LocalDate(2013, 8, 25)) == 0 ? 1 : 0) != 0);
        ((ClockMock)this.clock).resetDeltaFromReality();
    }

    @Test(groups={"fast"})
    public void testLocalDateConversion() {
        String input = "2013-08-25";
        LocalDate result = this.toLocalDate(this.accountId, "2013-08-25", null);
        Assert.assertTrue((result.compareTo((ReadablePartial)new LocalDate(2013, 8, 25)) == 0 ? 1 : 0) != 0);
    }
}

