/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.RefundJson;
import org.killbill.billing.payment.api.RefundStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRefundJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String refundId = UUID.randomUUID().toString();
        String paymentId = UUID.randomUUID().toString();
        BigDecimal amount = BigDecimal.TEN;
        String currency = "USD";
        boolean isAdjusted = true;
        DateTime requestedDate = this.clock.getUTCNow();
        DateTime effectiveDate = this.clock.getUTCNow();
        RefundStatus status = RefundStatus.COMPLETED;
        ImmutableList adjustments = ImmutableList.of((Object)this.createInvoiceItemJson());
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        RefundJson refundJson = new RefundJson(refundId, paymentId, amount, "USD", status.toString(), Boolean.valueOf(true), requestedDate, effectiveDate, (List)adjustments, auditLogs);
        Assert.assertEquals((String)refundJson.getRefundId(), (String)refundId);
        Assert.assertEquals((String)refundJson.getPaymentId(), (String)paymentId);
        Assert.assertEquals((Object)refundJson.getAmount(), (Object)amount);
        Assert.assertEquals((String)refundJson.getCurrency(), (String)"USD");
        Assert.assertEquals((boolean)refundJson.isAdjusted(), (boolean)true);
        Assert.assertEquals((Object)refundJson.getRequestedDate(), (Object)requestedDate);
        Assert.assertEquals((Object)refundJson.getEffectiveDate(), (Object)effectiveDate);
        Assert.assertEquals((Collection)refundJson.getAdjustments(), (Collection)adjustments);
        Assert.assertEquals((Collection)refundJson.getAuditLogs(), auditLogs);
        String asJson = this.mapper.writeValueAsString((Object)refundJson);
        RefundJson fromJson = (RefundJson)this.mapper.readValue(asJson, RefundJson.class);
        Assert.assertEquals((Object)fromJson, (Object)refundJson);
    }

    private InvoiceItemJson createInvoiceItemJson() {
        String invoiceItemId = UUID.randomUUID().toString();
        String invoiceId = UUID.randomUUID().toString();
        String linkedInvoiceItemId = UUID.randomUUID().toString();
        String accountId = UUID.randomUUID().toString();
        String bundleId = UUID.randomUUID().toString();
        String subscriptionId = UUID.randomUUID().toString();
        String planName = UUID.randomUUID().toString();
        String phaseName = UUID.randomUUID().toString();
        String usageName = UUID.randomUUID().toString();
        String description = UUID.randomUUID().toString();
        LocalDate startDate = this.clock.getUTCToday();
        LocalDate endDate = this.clock.getUTCToday();
        String type = "FIXED";
        BigDecimal amount = BigDecimal.TEN;
        Currency currency = Currency.MXN;
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        return new InvoiceItemJson(invoiceItemId, invoiceId, linkedInvoiceItemId, accountId, bundleId, subscriptionId, planName, phaseName, usageName, "FIXED", description, startDate, endDate, amount, currency, auditLogs);
    }
}

