/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.ChargebackJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestChargebackJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        DateTime requestedDate = new DateTime(DateTimeZone.UTC);
        DateTime effectiveDate = new DateTime(DateTimeZone.UTC);
        BigDecimal chargebackAmount = BigDecimal.TEN;
        String chargebackId = UUID.randomUUID().toString();
        String accountId = UUID.randomUUID().toString();
        String paymentId = UUID.randomUUID().toString();
        String currency = "USD";
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        ChargebackJson chargebackJson = new ChargebackJson(chargebackId, accountId, requestedDate, effectiveDate, chargebackAmount, paymentId, "USD", auditLogs);
        Assert.assertEquals((String)chargebackJson.getChargebackId(), (String)chargebackId);
        Assert.assertEquals((Object)chargebackJson.getRequestedDate(), (Object)requestedDate);
        Assert.assertEquals((Object)chargebackJson.getEffectiveDate(), (Object)effectiveDate);
        Assert.assertEquals((Object)chargebackJson.getAmount(), (Object)chargebackAmount);
        Assert.assertEquals((String)chargebackJson.getPaymentId(), (String)paymentId);
        Assert.assertEquals((Collection)chargebackJson.getAuditLogs(), auditLogs);
        String asJson = this.mapper.writeValueAsString((Object)chargebackJson);
        ChargebackJson fromJson = (ChargebackJson)this.mapper.readValue(asJson, ChargebackJson.class);
        Assert.assertEquals((Object)fromJson, (Object)chargebackJson);
    }
}

