/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.JaxrsTestUtils;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBundleJsonWithSubscriptions
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String someUUID = UUID.randomUUID().toString();
        UUID bundleId = UUID.randomUUID();
        String externalKey = UUID.randomUUID().toString();
        List<AuditLogJson> auditLogs = JaxrsTestUtils.createAuditLogsJson(this.clock.getUTCNow());
        SubscriptionJson.EventSubscriptionJson event = new SubscriptionJson.EventSubscriptionJson(someUUID, BillingPeriod.NO_BILLING_PERIOD.toString(), new LocalDate(), new LocalDate(), "product", "priceList", "eventType", "phase", null);
        SubscriptionJson subscription = new SubscriptionJson(someUUID, someUUID, someUUID, externalKey, new LocalDate(), someUUID, someUUID, someUUID, someUUID, new LocalDate(), new LocalDate(), new LocalDate(), new LocalDate(), (List)ImmutableList.of((Object)event), null, null, auditLogs);
        BundleJson bundleJson = new BundleJson(someUUID, bundleId.toString(), externalKey, (List)ImmutableList.of((Object)subscription), auditLogs);
        Assert.assertEquals((String)bundleJson.getBundleId(), (String)bundleId.toString());
        Assert.assertEquals((String)bundleJson.getExternalKey(), (String)externalKey);
        Assert.assertEquals((int)bundleJson.getSubscriptions().size(), (int)1);
        Assert.assertEquals((Collection)bundleJson.getAuditLogs(), auditLogs);
        String asJson = this.mapper.writeValueAsString((Object)bundleJson);
        BundleJson fromJson = (BundleJson)this.mapper.readValue(asJson, BundleJson.class);
        Assert.assertEquals((Object)fromJson, (Object)bundleJson);
    }
}

