/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Singleton;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.UsageJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.usage.api.RolledUpUsage;
import org.killbill.billing.usage.api.UsageUserApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/usages")
public class UsageResource
extends JaxRsResourceBase {
    private final UsageUserApi usageUserApi;

    @Inject
    public UsageResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, UsageUserApi usageUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.usageUserApi = usageUserApi;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response recordUsage(UsageJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        this.usageUserApi.recordRolledUpUsage(UUID.fromString(json.getSubscriptionId()), json.getUnitType(), json.getStartTime(), json.getEndTime(), json.getAmount(), callContext);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/{unitType}")
    @Produces(value={"application/json"})
    public Response getUsage(@PathParam(value="subscriptionId") String subscriptionId, @PathParam(value="unitType") String unitType, @QueryParam(value="startTime") String startTime, @QueryParam(value="endTime") String endTime, @Context HttpServletRequest request) {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        DateTime usageStartTime = this.DATE_TIME_FORMATTER.parseDateTime(startTime);
        DateTime usageEndTime = this.DATE_TIME_FORMATTER.parseDateTime(endTime);
        RolledUpUsage usage = this.usageUserApi.getUsageForSubscription(UUID.fromString(subscriptionId), unitType, usageStartTime, usageEndTime, tenantContext);
        UsageJson result = new UsageJson(usage);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }
}

