/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.RecordIdApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/test")
public class TestResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(TestResource.class);
    private static final int MILLIS_IN_SEC = 1000;
    private final NotificationQueueService notificationQueueService;
    private final RecordIdApi recordIdApi;

    @Inject
    public TestResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, RecordIdApi recordIdApi, NotificationQueueService notificationQueueService, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.notificationQueueService = notificationQueueService;
        this.recordIdApi = recordIdApi;
    }

    @GET
    @Path(value="/clock")
    @Produces(value={"application/json"})
    public Response getCurrentTime(@QueryParam(value="timeZone") String timeZoneStr) {
        DateTimeZone timeZone = timeZoneStr != null ? DateTimeZone.forID((String)timeZoneStr) : DateTimeZone.UTC;
        DateTime now = this.clock.getUTCNow();
        ClockResource result = new ClockResource(now, timeZone.getID(), new LocalDate((Object)now, timeZone));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/clock")
    @Produces(value={"application/json"})
    public Response setTestClockTime(@QueryParam(value="requestedDate") String requestedClockDate, @QueryParam(value="timeZone") String timeZoneStr, @QueryParam(value="timeoutSec") @DefaultValue(value="5") Long timeoutSec, @Context HttpServletRequest request) {
        ClockMock testClock = this.getClockMock();
        if (requestedClockDate == null) {
            log.info("************      RESETTING CLOCK to " + this.clock.getUTCNow());
            testClock.resetDeltaFromReality();
        } else {
            DateTime newTime = this.DATE_TIME_FORMATTER.parseDateTime(requestedClockDate);
            testClock.setTime(newTime);
        }
        this.waitForNotificationToComplete(request, timeoutSec);
        return this.getCurrentTime(timeZoneStr);
    }

    @PUT
    @Path(value="/clock")
    @Produces(value={"application/json"})
    public Response updateTestClockTime(@QueryParam(value="days") Integer addDays, @QueryParam(value="weeks") Integer addWeeks, @QueryParam(value="months") Integer addMonths, @QueryParam(value="years") Integer addYears, @QueryParam(value="timeZone") String timeZoneStr, @QueryParam(value="timeoutSec") @DefaultValue(value="5") Long timeoutSec, @Context HttpServletRequest request) {
        ClockMock testClock = this.getClockMock();
        if (addDays != null) {
            testClock.addDays(addDays.intValue());
        } else if (addWeeks != null) {
            testClock.addWeeks(addWeeks.intValue());
        } else if (addMonths != null) {
            testClock.addMonths(addMonths.intValue());
        } else if (addYears != null) {
            testClock.addYears(addYears.intValue());
        }
        this.waitForNotificationToComplete(request, timeoutSec);
        return this.getCurrentTime(timeZoneStr);
    }

    private void waitForNotificationToComplete(HttpServletRequest request, Long timeoutSec) {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Long tenantRecordId = this.recordIdApi.getRecordId(tenantContext.getTenantId(), ObjectType.TENANT, tenantContext);
        List queues = this.notificationQueueService.getNotificationQueues();
        int nbTryLeft = timeoutSec != null ? timeoutSec.intValue() : 0;
        try {
            boolean areAllNotificationsProcessed = false;
            while (!areAllNotificationsProcessed && nbTryLeft > 0) {
                areAllNotificationsProcessed = this.areAllNotificationsProcessed(queues, tenantRecordId);
                if (areAllNotificationsProcessed) continue;
                Thread.sleep(1000L);
                --nbTryLeft;
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    private boolean areAllNotificationsProcessed(List<NotificationQueue> queues, final Long tenantRecordId) {
        Iterable filtered = Iterables.filter(queues, (Predicate)new Predicate<NotificationQueue>(){

            public boolean apply(@Nullable NotificationQueue input) {
                return input.getReadyNotificationEntriesForSearchKey2(tenantRecordId) > 0;
            }
        });
        return !filtered.iterator().hasNext();
    }

    private ClockMock getClockMock() {
        if (!(this.clock instanceof ClockMock)) {
            throw new UnsupportedOperationException("Kill Bill has not been configured to update the time");
        }
        return (ClockMock)this.clock;
    }

    public final class ClockResource {
        private final DateTime currentUtcTime;
        private final String timeZone;
        private final LocalDate localDate;

        @JsonCreator
        public ClockResource(@JsonProperty(value="timeZone") DateTime currentUtcTime, @JsonProperty(value="localDate") String timeZone, LocalDate localDate) {
            this.currentUtcTime = currentUtcTime;
            this.timeZone = timeZone;
            this.localDate = localDate;
        }

        public DateTime getCurrentUtcTime() {
            return this.currentUtcTime;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public LocalDate getLocalDate() {
            return this.localDate;
        }
    }
}

