/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.TenantJson;
import org.killbill.billing.jaxrs.json.TenantKeyJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantData;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/tenants")
public class TenantResource
extends JaxRsResourceBase {
    private final TenantUserApi tenantApi;

    @Inject
    public TenantResource(TenantUserApi tenantApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.tenantApi = tenantApi;
    }

    @GET
    @Path(value="/{tenantId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getTenant(@PathParam(value="tenantId") String tenantId) throws TenantApiException {
        Tenant tenant = this.tenantApi.getTenantById(UUID.fromString(tenantId));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new TenantJson(tenant)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTenantByApiKey(@QueryParam(value="apiKey") String externalKey) throws TenantApiException {
        Tenant tenant = this.tenantApi.getTenantByApiKey(externalKey);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new TenantJson(tenant)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTenant(TenantJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws TenantApiException {
        TenantData data = json.toTenantData();
        Tenant tenant = this.tenantApi.createTenant(data, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return this.uriBuilder.buildResponse(uriInfo, TenantResource.class, "getTenant", tenant.getId());
    }

    @POST
    @Path(value="/registerNotificationCallback")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerPushNotificationCallback(@PathParam(value="tenantId") String tenantId, @QueryParam(value="cb") String notificationCallback, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TenantApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        this.tenantApi.addTenantKeyValue(TenantKV.TenantKey.PUSH_NOTIFICATION_CB.toString(), notificationCallback, callContext);
        URI uri = UriBuilder.fromResource(TenantResource.class).path(TenantResource.class, "getPushNotificationCallbacks").build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    @GET
    @Path(value="/registerNotificationCallback")
    @Produces(value={"application/json"})
    public Response getPushNotificationCallbacks(@Context HttpServletRequest request) throws TenantApiException {
        TenantContext tenatContext = this.context.createContext((ServletRequest)request);
        List values = this.tenantApi.getTenantValueForKey(TenantKV.TenantKey.PUSH_NOTIFICATION_CB.toString(), tenatContext);
        TenantKeyJson result = new TenantKeyJson(TenantKV.TenantKey.PUSH_NOTIFICATION_CB.toString(), values);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @DELETE
    @Path(value="/REGISTER_NOTIFICATION_CALLBACK")
    public Response deletePushNotificationCallbacks(@PathParam(value="tenantId") String tenantId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TenantApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        this.tenantApi.deleteTenantKey(TenantKV.TenantKey.PUSH_NOTIFICATION_CB.toString(), callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    protected ObjectType getObjectType() {
        return ObjectType.TENANT;
    }
}

