/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/tags")
public class TagResource
extends JaxRsResourceBase {
    @Inject
    public TagResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
    }

    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    public Response getTags(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination tags = this.tagUserApi.getTags(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(TagResource.class, "getTags", tags.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"audit", (Object)auditMode.getLevel().toString()));
        final HashMap<UUID, TagDefinition> tagDefinitionsCache = new HashMap<UUID, TagDefinition>();
        for (TagDefinition tagDefinition : this.tagUserApi.getTagDefinitions(tenantContext)) {
            tagDefinitionsCache.put(tagDefinition.getId(), tagDefinition);
        }
        return this.buildStreamingPaginationResponse(tags, new Function<Tag, TagJson>(){

            public TagJson apply(Tag tag) {
                TagDefinition tagDefinition = (TagDefinition)tagDefinitionsCache.get(tag.getTagDefinitionId());
                List auditLogs = TagResource.this.auditUserApi.getAuditLogs(tag.getId(), ObjectType.TAG, auditMode.getLevel(), tenantContext);
                return new TagJson(tag, tagDefinition, auditLogs);
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    public Response searchTags(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination tags = this.tagUserApi.searchTags(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(TagResource.class, "searchTags", tags.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"audit", (Object)auditMode.getLevel().toString()));
        final HashMap<UUID, TagDefinition> tagDefinitionsCache = new HashMap<UUID, TagDefinition>();
        for (TagDefinition tagDefinition : this.tagUserApi.getTagDefinitions(tenantContext)) {
            tagDefinitionsCache.put(tagDefinition.getId(), tagDefinition);
        }
        return this.buildStreamingPaginationResponse(tags, new Function<Tag, TagJson>(){

            public TagJson apply(Tag tag) {
                TagDefinition tagDefinition = (TagDefinition)tagDefinitionsCache.get(tag.getTagDefinitionId());
                List auditLogs = TagResource.this.auditUserApi.getAuditLogs(tag.getId(), ObjectType.TAG, auditMode.getLevel(), tenantContext);
                return new TagJson(tag, tagDefinition, auditLogs);
            }
        }, nextPageUri);
    }
}

