/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.TagDefinitionJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/tagDefinitions")
public class TagDefinitionResource
extends JaxRsResourceBase {
    @Inject
    public TagDefinitionResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTagDefinitions(@Context HttpServletRequest request, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode) {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        List tagDefinitions = this.tagUserApi.getTagDefinitions(tenantContext);
        LinkedList<TagDefinitionJson> result = new LinkedList<TagDefinitionJson>();
        for (TagDefinition tagDefinition : tagDefinitions) {
            List auditLogs = this.auditUserApi.getAuditLogs(tagDefinition.getId(), ObjectType.TAG_DEFINITION, auditMode.getLevel(), tenantContext);
            result.add(new TagDefinitionJson(tagDefinition, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @GET
    @Path(value="/{tagDefinitionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getTagDefinition(@PathParam(value="tagDefinitionId") String tagDefId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws TagDefinitionApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        TagDefinition tagDefinition = this.tagUserApi.getTagDefinition(UUID.fromString(tagDefId), tenantContext);
        List auditLogs = this.auditUserApi.getAuditLogs(tagDefinition.getId(), ObjectType.TAG_DEFINITION, auditMode.getLevel(), tenantContext);
        TagDefinitionJson json = new TagDefinitionJson(tagDefinition, auditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTagDefinition(TagDefinitionJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws TagDefinitionApiException {
        Preconditions.checkNotNull((Object)json.getName(), (Object)String.format("TagDefinition name needs to be set", new Object[0]));
        Preconditions.checkNotNull((Object)json.getDescription(), (Object)String.format("TagDefinition description needs to be set", new Object[0]));
        TagDefinition createdTagDef = this.tagUserApi.createTagDefinition(json.getName(), json.getDescription(), this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return this.uriBuilder.buildResponse(uriInfo, TagDefinitionResource.class, "getTagDefinition", createdTagDef.getId());
    }

    @DELETE
    @Path(value="/{tagDefinitionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response deleteTagDefinition(@PathParam(value="tagDefinitionId") String tagDefId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagDefinitionApiException {
        this.tagUserApi.deleteTagDefinition(UUID.fromString(tagDefId), this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    protected ObjectType getObjectType() {
        return ObjectType.TAG_DEFINITION;
    }
}

