/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.events.InvoiceCreationInternalEvent;
import org.killbill.billing.events.NullInvoiceInternalEvent;
import org.killbill.billing.events.PaymentErrorInternalEvent;
import org.killbill.billing.events.PaymentInfoInternalEvent;
import org.killbill.billing.events.PaymentPluginErrorInternalEvent;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.jaxrs.util.KillbillEventHandler;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.userrequest.CompletionUserRequest;
import org.killbill.billing.util.userrequest.CompletionUserRequestBase;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/subscriptions")
public class SubscriptionResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionResource.class);
    private static final String ID_PARAM_NAME = "subscriptionId";
    private final KillbillEventHandler killbillHandler;
    private final EntitlementApi entitlementApi;
    private final SubscriptionApi subscriptionApi;

    @Inject
    public SubscriptionResource(KillbillEventHandler killbillHandler, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, EntitlementApi entitlementApi, SubscriptionApi subscriptionApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.killbillHandler = killbillHandler;
        this.entitlementApi = entitlementApi;
        this.subscriptionApi = subscriptionApi;
    }

    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getEntitlement(@PathParam(value="subscriptionId") String subscriptionId, @Context HttpServletRequest request) throws SubscriptionApiException {
        UUID uuid = UUID.fromString(subscriptionId);
        Subscription subscription = this.subscriptionApi.getSubscriptionForEntitlementId(uuid, this.context.createContext((ServletRequest)request));
        SubscriptionJson json = new SubscriptionJson(subscription, null, null);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createEntitlement(final SubscriptionJson entitlement, final @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="3") long timeoutSec, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, final @Context UriInfo uriInfo) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        final CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        EntitlementCallCompletionCallback<Entitlement> callback = new EntitlementCallCompletionCallback<Entitlement>(){

            @Override
            public Entitlement doOperation(CallContext ctx) throws InterruptedException, TimeoutException, EntitlementApiException {
                PlanPhaseSpecifier spec = new PlanPhaseSpecifier(entitlement.getProductName(), ProductCategory.valueOf((String)entitlement.getProductCategory()), BillingPeriod.valueOf((String)entitlement.getBillingPeriod()), entitlement.getPriceList(), null);
                UUID accountId = entitlement.getAccountId() != null ? UUID.fromString(entitlement.getAccountId()) : null;
                LocalDate inputLocalDate = SubscriptionResource.this.toLocalDate(accountId, requestedDate, (TenantContext)callContext);
                UUID bundleId = entitlement.getBundleId() != null ? UUID.fromString(entitlement.getBundleId()) : null;
                return entitlement.getProductCategory().equals(ProductCategory.ADD_ON.toString()) ? SubscriptionResource.this.entitlementApi.addEntitlement(bundleId, spec, inputLocalDate, callContext) : SubscriptionResource.this.entitlementApi.createBaseEntitlement(accountId, spec, entitlement.getExternalKey(), inputLocalDate, callContext);
            }

            @Override
            public boolean isImmOperation() {
                return true;
            }

            @Override
            public Response doResponseOk(Entitlement createdEntitlement) {
                return SubscriptionResource.this.uriBuilder.buildResponse(uriInfo, SubscriptionResource.class, "getEntitlement", createdEntitlement.getId());
            }
        };
        EntitlementCallCompletion<Entitlement> callCompletionCreation = new EntitlementCallCompletion<Entitlement>();
        return callCompletionCreation.withSynchronization(callback, timeoutSec, callCompletion, callContext);
    }

    @PUT
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/uncancel")
    @Produces(value={"application/json"})
    public Response uncancelEntitlementPlan(@PathParam(value="subscriptionId") String subscriptionId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws EntitlementApiException {
        UUID uuid = UUID.fromString(subscriptionId);
        Entitlement current = this.entitlementApi.getEntitlementForId(uuid, (TenantContext)this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        current.uncancelEntitlement(this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    public Response changeEntitlementPlan(final SubscriptionJson entitlement, final @PathParam(value="subscriptionId") String subscriptionId, final @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="3") long timeoutSec, final @QueryParam(value="billingPolicy") String policyString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, final @Context HttpServletRequest request) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        final CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        EntitlementCallCompletionCallback<Response> callback = new EntitlementCallCompletionCallback<Response>(){
            private boolean isImmediateOp = true;

            @Override
            public Response doOperation(CallContext ctx) throws EntitlementApiException, InterruptedException, TimeoutException, AccountApiException {
                Entitlement newEntitlement;
                UUID uuid = UUID.fromString(subscriptionId);
                Entitlement current = SubscriptionResource.this.entitlementApi.getEntitlementForId(uuid, (TenantContext)callContext);
                LocalDate inputLocalDate = SubscriptionResource.this.toLocalDate(current.getAccountId(), requestedDate, (TenantContext)callContext);
                if (requestedDate == null && policyString == null) {
                    newEntitlement = current.changePlan(entitlement.getProductName(), BillingPeriod.valueOf((String)entitlement.getBillingPeriod()), entitlement.getPriceList(), ctx);
                } else if (policyString == null) {
                    newEntitlement = current.changePlanWithDate(entitlement.getProductName(), BillingPeriod.valueOf((String)entitlement.getBillingPeriod()), entitlement.getPriceList(), inputLocalDate, ctx);
                } else {
                    BillingActionPolicy policy = BillingActionPolicy.valueOf((String)policyString.toUpperCase());
                    newEntitlement = current.changePlanOverrideBillingPolicy(entitlement.getProductName(), BillingPeriod.valueOf((String)entitlement.getBillingPeriod()), entitlement.getPriceList(), inputLocalDate, policy, ctx);
                }
                this.isImmediateOp = newEntitlement.getLastActiveProduct().getName().equals(entitlement.getProductName()) && newEntitlement.getLastActivePlan().getRecurringBillingPeriod() == BillingPeriod.valueOf((String)entitlement.getBillingPeriod()) && newEntitlement.getLastActivePriceList().getName().equals(entitlement.getPriceList());
                return Response.status((Response.Status)Response.Status.OK).build();
            }

            @Override
            public boolean isImmOperation() {
                return this.isImmediateOp;
            }

            @Override
            public Response doResponseOk(Response operationResponse) throws SubscriptionApiException {
                if (operationResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                    return operationResponse;
                }
                return SubscriptionResource.this.getEntitlement(subscriptionId, request);
            }
        };
        EntitlementCallCompletion<Response> callCompletionCreation = new EntitlementCallCompletion<Response>();
        return callCompletionCreation.withSynchronization(callback, timeoutSec, callCompletion, callContext);
    }

    @DELETE
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response cancelEntitlementPlan(final @PathParam(value="subscriptionId") String subscriptionId, final @QueryParam(value="requestedDate") String requestedDate, @QueryParam(value="callCompletion") @DefaultValue(value="false") Boolean callCompletion, @QueryParam(value="callTimeoutSec") @DefaultValue(value="5") long timeoutSec, final @QueryParam(value="entitlementPolicy") String entitlementPolicyString, final @QueryParam(value="billingPolicy") String billingPolicyString, final @QueryParam(value="useRequestedDateForBilling") @DefaultValue(value="false") Boolean useRequestedDateForBilling, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws EntitlementApiException, AccountApiException, SubscriptionApiException {
        final CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        EntitlementCallCompletionCallback<Response> callback = new EntitlementCallCompletionCallback<Response>(){
            private boolean isImmediateOp = true;

            @Override
            public Response doOperation(CallContext ctx) throws EntitlementApiException, InterruptedException, TimeoutException, AccountApiException, SubscriptionApiException {
                Entitlement.EntitlementActionPolicy entitlementPolicy;
                Entitlement newEntitlement;
                UUID uuid = UUID.fromString(subscriptionId);
                Entitlement current = SubscriptionResource.this.entitlementApi.getEntitlementForId(uuid, (TenantContext)ctx);
                LocalDate inputLocalDate = SubscriptionResource.this.toLocalDate(current.getAccountId(), requestedDate, (TenantContext)callContext);
                if (billingPolicyString == null && entitlementPolicyString == null) {
                    newEntitlement = current.cancelEntitlementWithDate(inputLocalDate, useRequestedDateForBilling.booleanValue(), ctx);
                } else if (billingPolicyString == null && entitlementPolicyString != null) {
                    entitlementPolicy = Entitlement.EntitlementActionPolicy.valueOf((String)entitlementPolicyString);
                    newEntitlement = current.cancelEntitlementWithPolicy(entitlementPolicy, ctx);
                } else if (billingPolicyString != null && entitlementPolicyString == null) {
                    BillingActionPolicy billingPolicy = BillingActionPolicy.valueOf((String)billingPolicyString.toUpperCase());
                    newEntitlement = current.cancelEntitlementWithDateOverrideBillingPolicy(inputLocalDate, billingPolicy, ctx);
                } else {
                    entitlementPolicy = Entitlement.EntitlementActionPolicy.valueOf((String)entitlementPolicyString);
                    BillingActionPolicy billingPolicy = BillingActionPolicy.valueOf((String)billingPolicyString.toUpperCase());
                    newEntitlement = current.cancelEntitlementWithPolicyOverrideBillingPolicy(entitlementPolicy, billingPolicy, ctx);
                }
                Subscription subscription = SubscriptionResource.this.subscriptionApi.getSubscriptionForEntitlementId(newEntitlement.getId(), (TenantContext)ctx);
                LocalDate nowInAccountTimeZone = new LocalDate((Object)SubscriptionResource.this.clock.getUTCNow(), subscription.getBillingEndDate().getChronology().getZone());
                this.isImmediateOp = subscription.getBillingEndDate() != null && !subscription.getBillingEndDate().isAfter((ReadablePartial)nowInAccountTimeZone);
                return Response.status((Response.Status)Response.Status.OK).build();
            }

            @Override
            public boolean isImmOperation() {
                return this.isImmediateOp;
            }

            @Override
            public Response doResponseOk(Response operationResponse) {
                return operationResponse;
            }
        };
        EntitlementCallCompletion<Response> callCompletionCreation = new EntitlementCallCompletion<Response>();
        return callCompletionCreation.withSynchronization(callback, timeoutSec, callCompletion, callContext);
    }

    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    public Response getCustomFields(@PathParam(value="subscriptionId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @POST
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createCustomFields(@PathParam(value="subscriptionId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @DELETE
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteCustomFields(@PathParam(value="subscriptionId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @GET
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    public Response getTags(@PathParam(value="subscriptionId") String subscriptionIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @Context HttpServletRequest request) throws TagDefinitionApiException, SubscriptionApiException {
        UUID subscriptionId = UUID.fromString(subscriptionIdString);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Subscription subscription = this.subscriptionApi.getSubscriptionForEntitlementId(subscriptionId, tenantContext);
        return super.getTags(subscription.getAccountId(), subscriptionId, auditMode, includedDeleted, tenantContext);
    }

    @POST
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTags(@PathParam(value="subscriptionId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @DELETE
    @Path(value="/{subscriptionId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteTags(@PathParam(value="subscriptionId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(UUID.fromString(id), tagList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.SUBSCRIPTION;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntitlementCallCompletion<T> {
        private EntitlementCallCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response withSynchronization(EntitlementCallCompletionCallback<T> callback, long timeoutSec, boolean callCompletion, CallContext callContext) throws SubscriptionApiException, AccountApiException, EntitlementApiException {
            CompletionUserRequestEntitlement waiter = callCompletion ? new CompletionUserRequestEntitlement(callContext.getUserToken()) : null;
            try {
                if (waiter != null) {
                    SubscriptionResource.this.killbillHandler.registerCompletionUserRequestWaiter((CompletionUserRequest)waiter);
                }
                T operationValue = callback.doOperation(callContext);
                if (waiter != null && callback.isImmOperation()) {
                    waiter.waitForCompletion(timeoutSec * 1000L);
                }
                Response response = callback.doResponseOk(operationValue);
                return response;
            }
            catch (InterruptedException e) {
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response;
            }
            catch (TimeoutException e) {
                Response response = Response.status((Response.Status)Response.Status.fromStatusCode((int)408)).build();
                return response;
            }
            finally {
                if (waiter != null) {
                    SubscriptionResource.this.killbillHandler.unregisterCompletionUserRequestWaiter((CompletionUserRequest)waiter);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EntitlementCallCompletionCallback<T> {
        public T doOperation(CallContext var1) throws EntitlementApiException, InterruptedException, TimeoutException, AccountApiException, SubscriptionApiException;

        public boolean isImmOperation();

        public Response doResponseOk(T var1) throws SubscriptionApiException;
    }

    private static final class CompletionUserRequestEntitlement
    extends CompletionUserRequestBase {
        public CompletionUserRequestEntitlement(UUID userToken) {
            super(userToken);
        }

        public void onSubscriptionBaseTransition(EffectiveSubscriptionInternalEvent event) {
            log.info(String.format("Got event SubscriptionBaseTransition token = %s, type = %s, remaining = %d ", event.getUserToken(), event.getTransitionType(), event.getRemainingEventsForUserOperation()));
        }

        public void onEmptyInvoice(NullInvoiceInternalEvent event) {
            log.info(String.format("Got event EmptyInvoiceNotification token = %s ", event.getUserToken()));
            this.notifyForCompletion();
        }

        public void onInvoiceCreation(InvoiceCreationInternalEvent event) {
            log.info(String.format("Got event InvoiceCreationNotification token = %s ", event.getUserToken()));
            if (event.getAmountOwed().compareTo(BigDecimal.ZERO) <= 0) {
                this.notifyForCompletion();
            }
        }

        public void onPaymentInfo(PaymentInfoInternalEvent event) {
            log.info(String.format("Got event PaymentInfo token = %s ", event.getUserToken()));
            this.notifyForCompletion();
        }

        public void onPaymentError(PaymentErrorInternalEvent event) {
            log.info(String.format("Got event PaymentError token = %s ", event.getUserToken()));
            this.notifyForCompletion();
        }

        public void onPaymentPluginError(PaymentPluginErrorInternalEvent event) {
            log.info(String.format("Got event PaymentPluginError token = %s ", event.getUserToken()));
            this.notifyForCompletion();
        }
    }
}

