/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.SubjectJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/security")
public class SecurityResource
extends JaxRsResourceBase {
    private final SecurityApi securityApi;

    @Inject
    public SecurityResource(SecurityApi securityApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.securityApi = securityApi;
    }

    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json"})
    public Response getCurrentUserPermissions(@Context HttpServletRequest request) {
        Set permissions = this.securityApi.getCurrentUserPermissions(this.context.createContext((ServletRequest)request));
        ImmutableList json = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)permissions, (Function)Functions.toStringFunction()));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @GET
    @Path(value="/subject")
    @Produces(value={"application/json"})
    public Response getCurrentUserSubject(@Context HttpServletRequest request) {
        Subject subject = SecurityUtils.getSubject();
        SubjectJson subjectJson = new SubjectJson(subject);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)subjectJson).build();
    }
}

