/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.RefundJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.Refund;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;

@Path(value="/1.0/kb/refunds")
public class RefundResource
extends JaxRsResourceBase {
    private final PaymentApi paymentApi;

    @Inject
    public RefundResource(PaymentApi paymentApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.paymentApi = paymentApi;
    }

    @GET
    @Path(value="/{refundId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getRefund(@PathParam(value="refundId") String refundId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Refund refund = this.paymentApi.getRefund(UUID.fromString(refundId), false, tenantContext);
        List auditLogs = this.auditUserApi.getAuditLogs(refund.getId(), ObjectType.REFUND, auditMode.getLevel(), tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new RefundJson(refund, null, auditLogs)).build();
    }

    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    public Response getRefunds(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination refunds = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.getRefunds(offset, limit, tenantContext) : this.paymentApi.getRefunds(offset, limit, pluginName, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(RefundResource.class, "getRefunds", refunds.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap paymentIdAccountIdMappings = new HashMap();
        return this.buildStreamingPaginationResponse(refunds, new Function<Refund, RefundJson>(){

            public RefundJson apply(Refund refund) {
                UUID kbAccountId = null;
                if (!AuditLevel.NONE.equals((Object)auditMode.getLevel()) && paymentIdAccountIdMappings.get(refund.getPaymentId()) == null) {
                    try {
                        kbAccountId = RefundResource.this.paymentApi.getPayment(refund.getPaymentId(), false, tenantContext).getAccountId();
                        paymentIdAccountIdMappings.put(refund.getPaymentId(), kbAccountId);
                    }
                    catch (PaymentApiException e) {
                        JaxRsResourceBase.log.warn("Unable to retrieve payment for id " + refund.getPaymentId());
                    }
                }
                if (((Map)accountsAuditLogs.get()).get(kbAccountId) == null) {
                    ((Map)accountsAuditLogs.get()).put(kbAccountId, RefundResource.this.auditUserApi.getAccountAuditLogs(kbAccountId, auditMode.getLevel(), tenantContext));
                }
                List auditLogs = ((Map)accountsAuditLogs.get()).get(kbAccountId) == null ? null : ((AccountAuditLogs)((Map)accountsAuditLogs.get()).get(kbAccountId)).getAuditLogsForRefund(refund.getId());
                return new RefundJson(refund, null, auditLogs);
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    public Response searchRefunds(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination refunds = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.searchRefunds(searchKey, offset, limit, tenantContext) : this.paymentApi.searchRefunds(searchKey, offset, limit, pluginName, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(RefundResource.class, "searchRefunds", refunds.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap paymentIdAccountIdMappings = new HashMap();
        return this.buildStreamingPaginationResponse(refunds, new Function<Refund, RefundJson>(){

            public RefundJson apply(Refund refund) {
                UUID kbAccountId = null;
                if (!AuditLevel.NONE.equals((Object)auditMode.getLevel()) && paymentIdAccountIdMappings.get(refund.getPaymentId()) == null) {
                    try {
                        kbAccountId = RefundResource.this.paymentApi.getPayment(refund.getPaymentId(), false, tenantContext).getAccountId();
                        paymentIdAccountIdMappings.put(refund.getPaymentId(), kbAccountId);
                    }
                    catch (PaymentApiException e) {
                        JaxRsResourceBase.log.warn("Unable to retrieve payment for id " + refund.getPaymentId());
                    }
                }
                if (((Map)accountsAuditLogs.get()).get(kbAccountId) == null) {
                    ((Map)accountsAuditLogs.get()).put(kbAccountId, RefundResource.this.auditUserApi.getAccountAuditLogs(kbAccountId, auditMode.getLevel(), tenantContext));
                }
                List auditLogs = ((Map)accountsAuditLogs.get()).get(kbAccountId) == null ? null : ((AccountAuditLogs)((Map)accountsAuditLogs.get()).get(kbAccountId)).getAuditLogsForRefund(refund.getId());
                return new RefundJson(refund, null, auditLogs);
            }
        }, nextPageUri);
    }

    protected ObjectType getObjectType() {
        return ObjectType.REFUND;
    }
}

