/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Path(value="/plugins{subResources:.*}")
public class PluginResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(PluginResource.class);
    private static final String UTF_8_STRING = "UTF-8";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final HttpServlet osgiServlet;

    @Inject
    public PluginResource(@Named(value="osgi") HttpServlet osgiServlet, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.osgiServlet = osgiServlet;
    }

    @DELETE
    public Response doDELETE(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @Context ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(request, response, servletContext, servletConfig);
    }

    @GET
    public Response doGET(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @Context ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(request, response, servletContext, servletConfig);
    }

    @OPTIONS
    public Response doOPTIONS(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @Context ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(request, response, servletContext, servletConfig);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response doFormPOST(MultivaluedMap<String, String> form, @Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @Context ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(form, request, response, servletContext, servletConfig);
    }

    @POST
    public Response doPOST(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @Context ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(request, response, servletContext, servletConfig);
    }

    @PUT
    public Response doPUT(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @Context ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(request, response, servletContext, servletConfig);
    }

    @HEAD
    public Response doHEAD(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context ServletContext servletContext, @Context ServletConfig servletConfig) throws ServletException, IOException {
        this.serviceViaOSGIPlugin(request, response, servletContext, servletConfig);
        return Response.noContent().build();
    }

    private Response serviceViaOSGIPlugin(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(request, (InputStream)request.getInputStream(), response, servletContext, servletConfig);
    }

    private Response serviceViaOSGIPlugin(MultivaluedMap<String, String> form, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ServletConfig servletConfig) throws ServletException, IOException {
        return this.serviceViaOSGIPlugin(request, this.createInputStream(request, form), response, servletContext, servletConfig);
    }

    private Response serviceViaOSGIPlugin(HttpServletRequest request, InputStream inputStream, HttpServletResponse response, ServletContext servletContext, ServletConfig servletConfig) throws ServletException, IOException {
        this.prepareOSGIRequest(request, servletContext, servletConfig);
        this.osgiServlet.service((ServletRequest)new OSGIServletRequestWrapper(request, inputStream), (ServletResponse)new OSGIServletResponseWrapper(response));
        if (response.isCommitted()) {
            if (response.getStatus() >= 400) {
                log.warn("{} responded {}", (Object)request.getPathInfo(), (Object)response.getStatus());
            }
            return null;
        }
        return Response.status((int)response.getStatus()).build();
    }

    private InputStream createInputStream(HttpServletRequest request, MultivaluedMap<String, String> form) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HashMap<String, String> data = new HashMap<String, String>();
        for (String key : request.getParameterMap().keySet()) {
            data.put(key, request.getParameter(key));
        }
        for (String key : form.keySet()) {
            data.put(key, (String)form.getFirst((Object)key));
        }
        this.appendFormParametersToBody(out, data);
        ByteStreams.copy((InputStream)request.getInputStream(), (OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    private void appendFormParametersToBody(ByteArrayOutputStream out, Map<String, String> data) throws IOException {
        int idx = 0;
        for (String key : data.keySet()) {
            if (idx > 0) {
                out.write("&".getBytes(UTF_8));
            }
            out.write((key + "=" + URLEncoder.encode(data.get(key), UTF_8_STRING)).getBytes(UTF_8));
            ++idx;
        }
    }

    private void prepareOSGIRequest(HttpServletRequest request, ServletContext servletContext, ServletConfig servletConfig) {
        request.setAttribute("killbill.osgi.servletContext", (Object)servletContext);
        request.setAttribute("killbill.osgi.servletConfig", (Object)servletConfig);
    }

    private static final class OSGIServletResponseWrapper
    extends HttpServletResponseWrapper {
        public OSGIServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }
    }

    private static final class ServletInputStreamWrapper
    extends ServletInputStream {
        private final InputStream inputStream;

        public ServletInputStreamWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }
    }

    private static final class OSGIServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final InputStream inputStream;

        public OSGIServletRequestWrapper(HttpServletRequest request, InputStream inputStream) {
            super(request);
            this.inputStream = inputStream;
        }

        public String getPathInfo() {
            return super.getPathInfo().replace("/plugins", "");
        }

        public String getContextPath() {
            return "/plugins";
        }

        public String getServletPath() {
            return super.getServletPath().replace("/plugins", "");
        }

        public ServletInputStream getInputStream() throws IOException {
            return new ServletInputStreamWrapper(this.inputStream);
        }
    }
}

