/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentApi;
import org.killbill.billing.jaxrs.json.ChargebackJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.RefundJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.RefundResource;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.Refund;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/payments")
public class PaymentResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "paymentId";
    private final PaymentApi paymentApi;
    private final InvoicePaymentApi invoicePaymentApi;

    @Inject
    public PaymentResource(AccountUserApi accountUserApi, PaymentApi paymentApi, InvoicePaymentApi invoicePaymentApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.paymentApi = paymentApi;
        this.invoicePaymentApi = invoicePaymentApi;
    }

    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getPayment(@PathParam(value="paymentId") String paymentIdString, @QueryParam(value="withRefundsAndChargebacks") @DefaultValue(value="false") Boolean withRefundsAndChargebacks, @Context HttpServletRequest request) throws PaymentApiException {
        PaymentJson paymentJson;
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        UUID paymentId = UUID.fromString(paymentIdString);
        Payment payment = this.paymentApi.getPayment(paymentId, false, tenantContext);
        if (withRefundsAndChargebacks.booleanValue()) {
            ArrayList<RefundJson> refunds = new ArrayList<RefundJson>();
            for (Refund refund : this.paymentApi.getPaymentRefunds(paymentId, tenantContext)) {
                refunds.add(new RefundJson(refund));
            }
            ArrayList<ChargebackJson> chargebacks = new ArrayList<ChargebackJson>();
            for (InvoicePayment chargeback : this.invoicePaymentApi.getChargebacksByPaymentId(paymentId, tenantContext)) {
                chargebacks.add(new ChargebackJson(payment.getAccountId(), chargeback));
            }
            paymentJson = new PaymentJson(payment, null, refunds, chargebacks);
        } else {
            paymentJson = new PaymentJson(payment, null);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)paymentJson).build();
    }

    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    public Response getPayments(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination payments = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.getPayments(offset, limit, tenantContext) : this.paymentApi.getPayments(offset, limit, pluginName, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentResource.class, "getPayments", payments.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(payments, new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                if (((Map)accountsAuditLogs.get()).get(payment.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(payment.getAccountId(), PaymentResource.this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new PaymentJson(payment, ((AccountAuditLogs)((Map)accountsAuditLogs.get()).get(payment.getAccountId())).getAuditLogsForPayment(payment.getId()));
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    public Response searchPayments(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination payments = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.searchPayments(searchKey, offset, limit, tenantContext) : this.paymentApi.searchPayments(searchKey, offset, limit, pluginName, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentResource.class, "searchPayments", payments.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(payments, new Function<Payment, PaymentJson>(){

            public PaymentJson apply(Payment payment) {
                if (((Map)accountsAuditLogs.get()).get(payment.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(payment.getAccountId(), PaymentResource.this.auditUserApi.getAccountAuditLogs(payment.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new PaymentJson(payment, ((AccountAuditLogs)((Map)accountsAuditLogs.get()).get(payment.getAccountId())).getAuditLogsForPayment(payment.getId()));
            }
        }, nextPageUri);
    }

    @PUT
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response retryFailedPayment(@PathParam(value="paymentId") String paymentIdString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID paymentId = UUID.fromString(paymentIdString);
        Payment payment = this.paymentApi.getPayment(paymentId, false, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContext);
        Payment newPayment = this.paymentApi.retryPayment(account, paymentId, callContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new PaymentJson(newPayment, null)).build();
    }

    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebacks")
    @Produces(value={"application/json"})
    public Response getChargebacksForPayment(@PathParam(value="paymentId") String paymentId, @Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        List chargebacks = this.invoicePaymentApi.getChargebacksByPaymentId(UUID.fromString(paymentId), tenantContext);
        if (chargebacks.size() == 0) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        UUID invoicePaymentId = ((InvoicePayment)chargebacks.get(0)).getId();
        UUID accountId = this.invoicePaymentApi.getAccountIdFromInvoicePaymentId(invoicePaymentId, tenantContext);
        ArrayList<ChargebackJson> chargebacksJson = new ArrayList<ChargebackJson>();
        for (InvoicePayment chargeback : chargebacks) {
            chargebacksJson.add(new ChargebackJson(accountId, chargeback));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(chargebacksJson).build();
    }

    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/refunds")
    @Produces(value={"application/json"})
    public Response getRefunds(@PathParam(value="paymentId") String paymentId, @Context HttpServletRequest request) throws PaymentApiException {
        List refunds = this.paymentApi.getPaymentRefunds(UUID.fromString(paymentId), this.context.createContext((ServletRequest)request));
        ArrayList result = new ArrayList(Collections2.transform((Collection)refunds, (Function)new Function<Refund, RefundJson>(){

            public RefundJson apply(Refund input) {
                return new RefundJson(input, null, null);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/refunds")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRefund(RefundJson json, @PathParam(value="paymentId") String paymentId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        Refund result;
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID paymentUuid = UUID.fromString(paymentId);
        Payment payment = this.paymentApi.getPayment(paymentUuid, false, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(payment.getAccountId(), (TenantContext)callContext);
        if (json.isAdjusted()) {
            if (json.getAdjustments() != null && json.getAdjustments().size() > 0) {
                HashMap<UUID, BigDecimal> adjustments = new HashMap<UUID, BigDecimal>();
                for (InvoiceItemJson item : json.getAdjustments()) {
                    adjustments.put(UUID.fromString(item.getInvoiceItemId()), item.getAmount());
                }
                result = this.paymentApi.createRefundWithItemsAdjustments(account, paymentUuid, adjustments, callContext);
            } else {
                result = this.paymentApi.createRefundWithAdjustment(account, paymentUuid, json.getAmount(), callContext);
            }
        } else {
            result = this.paymentApi.createRefund(account, paymentUuid, json.getAmount(), callContext);
        }
        return this.uriBuilder.buildResponse(RefundResource.class, "getRefund", result.getId(), uriInfo.getBaseUri().toString());
    }

    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    public Response getCustomFields(@PathParam(value="paymentId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createCustomFields(@PathParam(value="paymentId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteCustomFields(@PathParam(value="paymentId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @GET
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    public Response getTags(@PathParam(value="paymentId") String paymentIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @Context HttpServletRequest request) throws TagDefinitionApiException, PaymentApiException {
        UUID paymentId = UUID.fromString(paymentIdString);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Payment payment = this.paymentApi.getPayment(paymentId, false, tenantContext);
        return super.getTags(payment.getAccountId(), paymentId, auditMode, includedDeleted, tenantContext);
    }

    @POST
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTags(@PathParam(value="paymentId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @DELETE
    @Path(value="/{paymentId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteTags(@PathParam(value="paymentId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(UUID.fromString(id), tagList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT;
    }
}

