/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/paymentMethods")
public class PaymentMethodResource
extends JaxRsResourceBase {
    private final PaymentApi paymentApi;

    @Inject
    public PaymentMethodResource(PaymentApi paymentApi, AccountUserApi accountUserApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.paymentApi = paymentApi;
    }

    @GET
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getPaymentMethod(@PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodById(UUID.fromString(paymentMethodId), false, withPluginInfo.booleanValue(), tenantContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext);
        PaymentMethodJson json = PaymentMethodJson.toPaymentMethodJson(account, paymentMethod, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    public Response getPaymentMethods(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination paymentMethods = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.getPaymentMethods(offset, limit, tenantContext) : this.paymentApi.getPaymentMethods(offset, limit, pluginName, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentMethodResource.class, "getPaymentMethods", paymentMethods.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap accounts = new HashMap();
        return this.buildStreamingPaginationResponse(paymentMethods, new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod paymentMethod) {
                if (((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(paymentMethod.getAccountId(), PaymentMethodResource.this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                if (accounts.get(paymentMethod.getAccountId()) == null) {
                    try {
                        Account account = PaymentMethodResource.this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
                        accounts.put(paymentMethod.getAccountId(), account);
                    }
                    catch (AccountApiException e) {
                        JaxRsResourceBase.log.warn("Unable to retrieve account", (Throwable)e);
                        return null;
                    }
                }
                return PaymentMethodJson.toPaymentMethodJson((Account)accounts.get(paymentMethod.getAccountId()), paymentMethod, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()));
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    public Response searchPaymentMethods(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, @QueryParam(value="pluginName") String pluginName, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination paymentMethods = Strings.isNullOrEmpty((String)pluginName) ? this.paymentApi.searchPaymentMethods(searchKey, offset, limit, tenantContext) : this.paymentApi.searchPaymentMethods(searchKey, offset, limit, pluginName, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(PaymentMethodResource.class, "searchPaymentMethods", paymentMethods.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        final HashMap accounts = new HashMap();
        return this.buildStreamingPaginationResponse(paymentMethods, new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod paymentMethod) {
                if (((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(paymentMethod.getAccountId(), PaymentMethodResource.this.auditUserApi.getAccountAuditLogs(paymentMethod.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                if (accounts.get(paymentMethod.getAccountId()) == null) {
                    try {
                        Account account = PaymentMethodResource.this.accountUserApi.getAccountById(paymentMethod.getAccountId(), tenantContext);
                        accounts.put(paymentMethod.getAccountId(), account);
                    }
                    catch (AccountApiException e) {
                        JaxRsResourceBase.log.warn("Unable to retrieve account", (Throwable)e);
                        return null;
                    }
                }
                return PaymentMethodJson.toPaymentMethodJson((Account)accounts.get(paymentMethod.getAccountId()), paymentMethod, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(paymentMethod.getAccountId()));
            }
        }, nextPageUri);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    public Response deletePaymentMethod(@PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="deleteDefaultPmWithAutoPayOff") @DefaultValue(value="false") Boolean deleteDefaultPaymentMethodWithAutoPayOff, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws PaymentApiException, AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        PaymentMethod paymentMethod = this.paymentApi.getPaymentMethodById(UUID.fromString(paymentMethodId), false, false, (TenantContext)callContext);
        Account account = this.accountUserApi.getAccountById(paymentMethod.getAccountId(), (TenantContext)callContext);
        this.paymentApi.deletedPaymentMethod(account, UUID.fromString(paymentMethodId), deleteDefaultPaymentMethodWithAutoPayOff.booleanValue(), callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    protected ObjectType getObjectType() {
        return ObjectType.PAYMENT_METHOD;
    }
}

