/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.TagJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxrsResource;
import org.killbill.billing.jaxrs.util.Context;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogsForObjectType;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.StringCustomField;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxRsResourceBase
implements JaxrsResource {
    static final Logger log = LoggerFactory.getLogger(JaxRsResourceBase.class);
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected final JaxrsUriBuilder uriBuilder;
    protected final TagUserApi tagUserApi;
    protected final CustomFieldUserApi customFieldUserApi;
    protected final AuditUserApi auditUserApi;
    protected final AccountUserApi accountUserApi;
    protected final Context context;
    protected final Clock clock;
    protected final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTimeParser();
    protected final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    public JaxRsResourceBase(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, Context context) {
        this.uriBuilder = uriBuilder;
        this.tagUserApi = tagUserApi;
        this.customFieldUserApi = customFieldUserApi;
        this.auditUserApi = auditUserApi;
        this.accountUserApi = accountUserApi;
        this.clock = clock;
        this.context = context;
    }

    protected ObjectType getObjectType() {
        return null;
    }

    protected Response getTags(UUID accountId, UUID taggedObjectId, AuditMode auditMode, boolean includeDeleted, TenantContext context) throws TagDefinitionApiException {
        List tags = this.tagUserApi.getTagsForObject(taggedObjectId, this.getObjectType(), includeDeleted, context);
        AccountAuditLogsForObjectType tagsAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, ObjectType.TAG, auditMode.getLevel(), context);
        HashMap<UUID, TagDefinition> tagDefinitionsCache = new HashMap<UUID, TagDefinition>();
        LinkedList<TagJson> result = new LinkedList<TagJson>();
        for (Tag tag : tags) {
            if (tagDefinitionsCache.get(tag.getTagDefinitionId()) == null) {
                tagDefinitionsCache.put(tag.getTagDefinitionId(), this.tagUserApi.getTagDefinition(tag.getTagDefinitionId(), context));
            }
            TagDefinition tagDefinition = (TagDefinition)tagDefinitionsCache.get(tag.getTagDefinitionId());
            List auditLogs = tagsAuditLogs.getAuditLogs(tag.getId());
            result.add(new TagJson(tag, tagDefinition, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    protected Response createTags(UUID id, String tagList, UriInfo uriInfo, CallContext context) throws TagApiException {
        Collection<UUID> input = this.getTagDefinitionUUIDs(tagList);
        this.tagUserApi.addTags(id, this.getObjectType(), input, context);
        return this.uriBuilder.buildResponse(this.getClass(), "getTags", id, uriInfo.getBaseUri().toString());
    }

    protected Collection<UUID> getTagDefinitionUUIDs(String tagList) {
        Object[] tagParts = tagList.split(",\\s*");
        return Collections2.transform((Collection)ImmutableList.copyOf((Object[])tagParts), (Function)new Function<String, UUID>(){

            public UUID apply(String input) {
                return UUID.fromString(input);
            }
        });
    }

    protected Response deleteTags(UUID id, String tagList, CallContext context) throws TagApiException {
        Collection<UUID> input = this.getTagDefinitionUUIDs(tagList);
        this.tagUserApi.removeTags(id, this.getObjectType(), input, context);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    protected Response getCustomFields(UUID id, AuditMode auditMode, TenantContext context) {
        List fields = this.customFieldUserApi.getCustomFieldsForObject(id, this.getObjectType(), context);
        LinkedList<CustomFieldJson> result = new LinkedList<CustomFieldJson>();
        for (CustomField cur : fields) {
            List auditLogs = this.auditUserApi.getAuditLogs(cur.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), context);
            result.add(new CustomFieldJson(cur, auditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    protected Response createCustomFields(UUID id, List<CustomFieldJson> customFields, CallContext context, UriInfo uriInfo) throws CustomFieldApiException {
        LinkedList<StringCustomField> input = new LinkedList<StringCustomField>();
        for (CustomFieldJson cur : customFields) {
            input.add(new StringCustomField(cur.getName(), cur.getValue(), this.getObjectType(), id, context.getCreatedDate()));
        }
        this.customFieldUserApi.addCustomFields(input, context);
        return this.uriBuilder.buildResponse(uriInfo, this.getClass(), "getCustomFields", id);
    }

    protected Response deleteCustomFields(UUID id, final @Nullable String customFieldList, CallContext context) throws CustomFieldApiException {
        String[] requestedIds;
        List fields = this.customFieldUserApi.getCustomFieldsForObject(id, this.getObjectType(), (TenantContext)context);
        Iterable inputIterable = Iterables.filter((Iterable)fields, (Predicate)new Predicate<CustomField>(requestedIds = customFieldList != null ? customFieldList.split("\\s*,\\s*") : null){
            final /* synthetic */ String[] val$requestedIds;
            {
                this.val$requestedIds = stringArray;
            }

            public boolean apply(CustomField input) {
                if (customFieldList == null) {
                    return true;
                }
                for (String cur : this.val$requestedIds) {
                    UUID curId = UUID.fromString(cur);
                    if (!input.getId().equals(curId)) continue;
                    return true;
                }
                return false;
            }
        });
        if (inputIterable.iterator().hasNext()) {
            ImmutableList input = ImmutableList.copyOf((Iterable)inputIterable);
            this.customFieldUserApi.removeCustomFields((List)input, context);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    protected <E extends Entity, J extends JsonBase> Response buildStreamingPaginationResponse(final Pagination<E> entities, final Function<E, J> toJson, URI nextPageUri) {
        StreamingOutput json = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                JsonGenerator generator = mapper.getFactory().createJsonGenerator(output);
                generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                generator.writeStartArray();
                for (Entity entity : entities) {
                    generator.writeObject(toJson.apply((Object)entity));
                }
                generator.writeEndArray();
                generator.close();
            }
        };
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).header("X-Killbill-Pagination-CurrentOffset", (Object)entities.getCurrentOffset()).header("X-Killbill-Pagination-NextOffset", (Object)entities.getNextOffset()).header("X-Killbill-Pagination-TotalNbRecords", (Object)entities.getTotalNbRecords()).header("X-Killbill-Pagination-MaxNbRecords", (Object)entities.getMaxNbRecords()).header("X-Killbill-Pagination-NextPageUri", (Object)nextPageUri).build();
    }

    protected LocalDate toLocalDate(UUID accountId, String inputDate, TenantContext context) {
        LocalDate maybeResult = this.extractLocalDate(inputDate);
        if (maybeResult != null) {
            return maybeResult;
        }
        Account account = null;
        try {
            account = accountId != null ? this.accountUserApi.getAccountById(accountId, context) : null;
        }
        catch (AccountApiException e) {
            log.info("Failed to retrieve account for id " + accountId);
        }
        DateTime inputDateTime = inputDate != null ? this.DATE_TIME_FORMATTER.parseDateTime(inputDate) : this.clock.getUTCNow();
        return this.toLocalDate(account, inputDateTime, context);
    }

    protected LocalDate toLocalDate(Account account, String inputDate, TenantContext context) {
        LocalDate maybeResult = this.extractLocalDate(inputDate);
        if (maybeResult != null) {
            return maybeResult;
        }
        DateTime inputDateTime = inputDate != null ? this.DATE_TIME_FORMATTER.parseDateTime(inputDate) : this.clock.getUTCNow();
        return this.toLocalDate(account, inputDateTime, context);
    }

    private LocalDate toLocalDate(Account account, DateTime inputDate, TenantContext context) {
        if (account == null && inputDate == null) {
            return new LocalDate((Object)this.clock.getUTCNow(), DateTimeZone.UTC);
        }
        if (account == null && inputDate != null) {
            return new LocalDate((Object)inputDate, DateTimeZone.UTC);
        }
        if (account != null && inputDate == null) {
            return new LocalDate((Object)this.clock.getUTCNow(), account.getTimeZone());
        }
        return new LocalDate((Object)inputDate, account.getTimeZone());
    }

    private LocalDate extractLocalDate(String inputDate) {
        if (inputDate != null) {
            try {
                LocalDate localDate = LocalDate.parse((String)inputDate, (DateTimeFormatter)this.LOCAL_DATE_FORMATTER);
                return localDate;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

