/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceNotifier;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AccountAuditLogsForObjectType;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/1.0/kb/invoices")
public class InvoiceResource
extends JaxRsResourceBase {
    private static final Logger log = LoggerFactory.getLogger(InvoiceResource.class);
    private static final String ID_PARAM_NAME = "invoiceId";
    private final InvoiceUserApi invoiceApi;
    private final PaymentApi paymentApi;
    private final InvoiceNotifier invoiceNotifier;

    @Inject
    public InvoiceResource(AccountUserApi accountUserApi, InvoiceUserApi invoiceApi, PaymentApi paymentApi, InvoiceNotifier invoiceNotifier, Clock clock, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.invoiceApi = invoiceApi;
        this.paymentApi = paymentApi;
        this.invoiceNotifier = invoiceNotifier;
    }

    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/")
    @Produces(value={"application/json"})
    public Response getInvoice(@PathParam(value="invoiceId") String invoiceId, @QueryParam(value="withItems") @DefaultValue(value="false") boolean withItems, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(UUID.fromString(invoiceId), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext);
        if (invoice == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_NOT_FOUND, new Object[]{invoiceId});
        }
        InvoiceJson json = new InvoiceJson(invoice, withItems, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @GET
    @Path(value="/{invoiceNumber:[0-9]+}/")
    @Produces(value={"application/json"})
    public Response getInvoiceByNumber(@PathParam(value="invoiceNumber") Integer invoiceNumber, @QueryParam(value="withItems") @DefaultValue(value="false") boolean withItems, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoiceByNumber(invoiceNumber, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext);
        if (invoice == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_NOT_FOUND, new Object[]{invoiceNumber});
        }
        InvoiceJson json = new InvoiceJson(invoice, withItems, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/html")
    @Produces(value={"text/html"})
    public Response getInvoiceAsHTML(@PathParam(value="invoiceId") String invoiceId, @Context HttpServletRequest request) throws InvoiceApiException, IOException, AccountApiException {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.invoiceApi.getInvoiceAsHTML(UUID.fromString(invoiceId), this.context.createContext((ServletRequest)request))).build();
    }

    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    public Response getInvoices(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="withItems") @DefaultValue(value="false") Boolean withItems, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws InvoiceApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination invoices = this.invoiceApi.getInvoices(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(InvoiceResource.class, "getInvoices", invoices.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"withItems", (Object)withItems.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(invoices, new Function<Invoice, InvoiceJson>(){

            public InvoiceJson apply(Invoice invoice) {
                if (((Map)accountsAuditLogs.get()).get(invoice.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(invoice.getAccountId(), InvoiceResource.this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new InvoiceJson(invoice, withItems, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(invoice.getAccountId()));
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    public Response searchInvoices(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="withItems") @DefaultValue(value="false") Boolean withItems, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws SubscriptionApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination invoices = this.invoiceApi.searchInvoices(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(InvoiceResource.class, "searchInvoices", invoices.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"withItems", (Object)withItems.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        final AtomicReference accountsAuditLogs = new AtomicReference(new HashMap());
        return this.buildStreamingPaginationResponse(invoices, new Function<Invoice, InvoiceJson>(){

            public InvoiceJson apply(Invoice invoice) {
                if (((Map)accountsAuditLogs.get()).get(invoice.getAccountId()) == null) {
                    ((Map)accountsAuditLogs.get()).put(invoice.getAccountId(), InvoiceResource.this.auditUserApi.getAccountAuditLogs(invoice.getAccountId(), auditMode.getLevel(), tenantContext));
                }
                return new InvoiceJson(invoice, withItems, (AccountAuditLogs)((Map)accountsAuditLogs.get()).get(invoice.getAccountId()));
            }
        }, nextPageUri);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFutureInvoice(@QueryParam(value="accountId") String accountId, @QueryParam(value="targetDate") String targetDateTime, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        LocalDate inputDate = this.toLocalDate(UUID.fromString(accountId), targetDateTime, (TenantContext)callContext);
        Invoice generatedInvoice = this.invoiceApi.triggerInvoiceGeneration(UUID.fromString(accountId), inputDate, dryRun.booleanValue(), callContext);
        if (dryRun.booleanValue()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new InvoiceJson(generatedInvoice)).build();
        }
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getInvoice", generatedInvoice.getId());
    }

    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/{invoiceItemId:\\w+-\\w+-\\w+-\\w+-\\w+}/cba")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteCBA(@PathParam(value="invoiceId") String invoiceId, @PathParam(value="invoiceItemId") String invoiceItemId, @QueryParam(value="accountId") String accountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        this.invoiceApi.deleteCBA(account.getId(), UUID.fromString(invoiceId), UUID.fromString(invoiceItemId), callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response adjustInvoiceItem(InvoiceItemJson json, @PathParam(value="invoiceId") String invoiceId, @QueryParam(value="requestedDate") String requestedDateTimeString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(json.getAccountId());
        LocalDate requestedDate = this.toLocalDate(accountId, requestedDateTimeString, (TenantContext)callContext);
        InvoiceItem adjustmentItem = json.getAmount() == null ? this.invoiceApi.insertInvoiceItemAdjustment(accountId, UUID.fromString(invoiceId), UUID.fromString(json.getInvoiceItemId()), requestedDate, callContext) : this.invoiceApi.insertInvoiceItemAdjustment(accountId, UUID.fromString(invoiceId), UUID.fromString(json.getInvoiceItemId()), requestedDate, json.getAmount(), json.getCurrency(), callContext);
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getInvoice", adjustmentItem.getInvoiceId());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/charges")
    public Response createExternalCharge(InvoiceItemJson externalChargeJson, @QueryParam(value="requestedDate") String requestedDateTimeString, @QueryParam(value="payInvoice") @DefaultValue(value="false") Boolean payInvoice, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws AccountApiException, InvoiceApiException, PaymentApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(externalChargeJson.getAccountId()), (TenantContext)callContext);
        LocalDate requestedDate = this.toLocalDate(account, requestedDateTimeString, (TenantContext)callContext);
        Currency currency = (Currency)Objects.firstNonNull((Object)externalChargeJson.getCurrency(), (Object)account.getCurrency());
        InvoiceItem externalCharge = externalChargeJson.getBundleId() != null ? this.invoiceApi.insertExternalChargeForBundle(account.getId(), UUID.fromString(externalChargeJson.getBundleId()), externalChargeJson.getAmount(), externalChargeJson.getDescription(), requestedDate, currency, callContext) : this.invoiceApi.insertExternalCharge(account.getId(), externalChargeJson.getAmount(), externalChargeJson.getDescription(), requestedDate, currency, callContext);
        if (payInvoice.booleanValue()) {
            Invoice invoice = this.invoiceApi.getInvoice(externalCharge.getInvoiceId(), (TenantContext)callContext);
            this.paymentApi.createPayment(account, invoice.getId(), invoice.getBalance(), callContext);
        }
        return this.uriBuilder.buildResponse(InvoiceResource.class, "getInvoice", externalCharge.getInvoiceId(), uriInfo.getBaseUri().toString());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/charges")
    public Response createExternalChargeForInvoice(InvoiceItemJson externalChargeJson, @PathParam(value="invoiceId") String invoiceIdString, @QueryParam(value="requestedDate") String requestedDateTimeString, @QueryParam(value="payInvoice") @DefaultValue(value="false") Boolean payInvoice, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws AccountApiException, InvoiceApiException, PaymentApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(externalChargeJson.getAccountId()), (TenantContext)callContext);
        LocalDate requestedDate = this.toLocalDate(account, requestedDateTimeString, (TenantContext)callContext);
        UUID invoiceId = UUID.fromString(invoiceIdString);
        Currency currency = (Currency)Objects.firstNonNull((Object)externalChargeJson.getCurrency(), (Object)account.getCurrency());
        InvoiceItem externalCharge = externalChargeJson.getBundleId() != null ? this.invoiceApi.insertExternalChargeForInvoiceAndBundle(account.getId(), invoiceId, UUID.fromString(externalChargeJson.getBundleId()), externalChargeJson.getAmount(), externalChargeJson.getDescription(), requestedDate, currency, callContext) : this.invoiceApi.insertExternalChargeForInvoice(account.getId(), invoiceId, externalChargeJson.getAmount(), externalChargeJson.getDescription(), requestedDate, currency, callContext);
        if (payInvoice.booleanValue()) {
            Invoice invoice = this.invoiceApi.getInvoice(externalCharge.getInvoiceId(), (TenantContext)callContext);
            this.paymentApi.createPayment(account, invoice.getId(), invoice.getBalance(), callContext);
        }
        return this.uriBuilder.buildResponse(InvoiceResource.class, "getInvoice", externalCharge.getInvoiceId(), uriInfo.getBaseUri().toString());
    }

    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Produces(value={"application/json"})
    public Response getPayments(@PathParam(value="invoiceId") String invoiceId, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws PaymentApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        List payments = this.paymentApi.getInvoicePayments(UUID.fromString(invoiceId), tenantContext);
        ArrayList<PaymentJson> result = new ArrayList<PaymentJson>(payments.size());
        if (payments.size() == 0) {
            return Response.status((Response.Status)Response.Status.OK).entity(result).build();
        }
        AccountAuditLogsForObjectType auditLogsForPayments = this.auditUserApi.getAccountAuditLogs(((Payment)payments.get(0)).getAccountId(), ObjectType.PAYMENT, auditMode.getLevel(), tenantContext);
        for (Payment cur : payments) {
            result.add(new PaymentJson(cur, auditLogsForPayments.getAuditLogs(cur.getId())));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    public Response createInstantPayment(PaymentJson payment, @QueryParam(value="externalPayment") @DefaultValue(value="false") Boolean externalPayment, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws AccountApiException, PaymentApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(payment.getAccountId()), (TenantContext)callContext);
        UUID invoiceId = UUID.fromString(payment.getInvoiceId());
        if (externalPayment.booleanValue()) {
            this.paymentApi.createExternalPayment(account, invoiceId, payment.getAmount(), callContext);
        } else {
            this.paymentApi.createPayment(account, invoiceId, payment.getAmount(), callContext);
        }
        return this.uriBuilder.buildResponse(uriInfo, InvoiceResource.class, "getPayments", (Object)payment.getInvoiceId());
    }

    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/emailNotifications")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response triggerEmailNotificationForInvoice(@PathParam(value="invoiceId") String invoiceId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws InvoiceApiException, AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(UUID.fromString(invoiceId), (TenantContext)callContext);
        if (invoice == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_NOT_FOUND, new Object[]{invoiceId});
        }
        Account account = this.accountUserApi.getAccountById(invoice.getAccountId(), (TenantContext)callContext);
        this.invoiceNotifier.notify(account, invoice, (TenantContext)callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    public Response getCustomFields(@PathParam(value="invoiceId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createCustomFields(@PathParam(value="invoiceId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteCustomFields(@PathParam(value="invoiceId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @GET
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    public Response getTags(@PathParam(value="invoiceId") String invoiceIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @Context HttpServletRequest request) throws TagDefinitionApiException, InvoiceApiException {
        UUID invoiceId = UUID.fromString(invoiceIdString);
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Invoice invoice = this.invoiceApi.getInvoice(invoiceId, tenantContext);
        return super.getTags(invoice.getAccountId(), invoiceId, auditMode, includedDeleted, tenantContext);
    }

    @POST
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTags(@PathParam(value="invoiceId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @DELETE
    @Path(value="/{invoiceId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteTags(@PathParam(value="invoiceId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException {
        return super.deleteTags(UUID.fromString(id), tagList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.INVOICE;
    }
}

