/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.StreamingOutput;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.ExportUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/export")
public class ExportResource
extends JaxRsResourceBase {
    private final ExportUserApi exportUserApi;

    @Inject
    public ExportResource(ExportUserApi exportUserApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.exportUserApi = exportUserApi;
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"text/plain"})
    public StreamingOutput exportDataForAccount(final @PathParam(value="accountId") String accountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) {
        final CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                ExportResource.this.exportUserApi.exportDataAsCSVForAccount(UUID.fromString(accountId), output, callContext);
            }
        };
    }
}

