/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/customFields")
public class CustomFieldResource
extends JaxRsResourceBase {
    @Inject
    public CustomFieldResource(JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
    }

    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    public Response getCustomFields(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws CustomFieldApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination customFields = this.customFieldUserApi.getCustomFields(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(CustomFieldResource.class, "getCustomFields", customFields.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(customFields, new Function<CustomField, CustomFieldJson>(){

            public CustomFieldJson apply(CustomField customField) {
                List auditLogs = CustomFieldResource.this.auditUserApi.getAuditLogs(customField.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), tenantContext);
                return new CustomFieldJson(customField, auditLogs);
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    public Response searchCustomFields(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws CustomFieldApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination customFields = this.customFieldUserApi.searchCustomFields(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(CustomFieldResource.class, "searchCustomFields", customFields.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(customFields, new Function<CustomField, CustomFieldJson>(){

            public CustomFieldJson apply(CustomField customField) {
                List auditLogs = CustomFieldResource.this.auditUserApi.getAuditLogs(customField.getId(), ObjectType.CUSTOM_FIELD, auditMode.getLevel(), tenantContext);
                return new CustomFieldJson(customField, auditLogs);
            }
        }, nextPageUri);
    }
}

