/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.LocalDate;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.CreditJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/credits")
public class CreditResource
extends JaxRsResourceBase {
    private final InvoiceUserApi invoiceUserApi;
    private final AccountUserApi accountUserApi;

    @Inject
    public CreditResource(InvoiceUserApi invoiceUserApi, AccountUserApi accountUserApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.invoiceUserApi = invoiceUserApi;
        this.accountUserApi = accountUserApi;
    }

    @GET
    @Path(value="/{creditId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getCredit(@PathParam(value="creditId") String creditId, @Context HttpServletRequest request) throws InvoiceApiException, AccountApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        InvoiceItem credit = this.invoiceUserApi.getCreditById(UUID.fromString(creditId), tenantContext);
        Invoice invoice = this.invoiceUserApi.getInvoice(credit.getInvoiceId(), tenantContext);
        CreditJson creditJson = new CreditJson(invoice, credit);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)creditJson).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createCredit(CreditJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws AccountApiException, InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(json.getAccountId()), (TenantContext)callContext);
        LocalDate effectiveDate = new LocalDate((Object)this.clock.getUTCNow(), account.getTimeZone());
        InvoiceItem credit = json.getInvoiceId() != null ? this.invoiceUserApi.insertCreditForInvoice(account.getId(), UUID.fromString(json.getInvoiceId()), json.getCreditAmount(), effectiveDate, account.getCurrency(), callContext) : this.invoiceUserApi.insertCredit(account.getId(), json.getCreditAmount(), effectiveDate, account.getCurrency(), callContext);
        return this.uriBuilder.buildResponse(uriInfo, CreditResource.class, "getCredit", credit.getId());
    }

    protected ObjectType getObjectType() {
        return ObjectType.INVOICE_ITEM;
    }
}

