/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentApi;
import org.killbill.billing.jaxrs.json.ChargebackJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/chargebacks")
public class ChargebackResource
extends JaxRsResourceBase {
    private final InvoicePaymentApi invoicePaymentApi;

    @Inject
    public ChargebackResource(InvoicePaymentApi invoicePaymentApi, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.invoicePaymentApi = invoicePaymentApi;
    }

    @GET
    @Path(value="/{chargebackId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getChargeback(@PathParam(value="chargebackId") String chargebackId, @Context HttpServletRequest request) throws InvoiceApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        InvoicePayment chargeback = this.invoicePaymentApi.getChargebackById(UUID.fromString(chargebackId), tenantContext);
        UUID accountId = this.invoicePaymentApi.getAccountIdFromInvoicePaymentId(chargeback.getId(), tenantContext);
        ChargebackJson chargebackJson = new ChargebackJson(accountId, chargeback);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)chargebackJson).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createChargeback(ChargebackJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws InvoiceApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        InvoicePayment invoicePayment = this.invoicePaymentApi.getInvoicePaymentForAttempt(UUID.fromString(json.getPaymentId()), (TenantContext)callContext);
        if (invoicePayment == null) {
            throw new InvoiceApiException(ErrorCode.INVOICE_PAYMENT_NOT_FOUND, new Object[]{json.getPaymentId()});
        }
        InvoicePayment chargeBack = this.invoicePaymentApi.createChargeback(invoicePayment.getId(), json.getAmount(), callContext);
        return this.uriBuilder.buildResponse(uriInfo, ChargebackResource.class, "getChargeback", chargeBack.getId());
    }

    protected ObjectType getObjectType() {
        return ObjectType.INVOICE_PAYMENT;
    }
}

