/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.jaxrs.json.CatalogJsonSimple;
import org.killbill.billing.jaxrs.json.PlanDetailJson;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.config.catalog.XMLWriter;
import org.killbill.clock.Clock;

@Singleton
@Path(value="/1.0/kb/catalog")
public class CatalogResource
extends JaxRsResourceBase {
    private final CatalogService catalogService;

    @Inject
    public CatalogResource(CatalogService catalogService, JaxrsUriBuilder uriBuilder, TagUserApi tagUserApi, CustomFieldUserApi customFieldUserApi, AuditUserApi auditUserApi, AccountUserApi accountUserApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountUserApi, clock, context);
        this.catalogService = catalogService;
    }

    @GET
    @Produces(value={"application/xml"})
    public Response getCatalogXml(@Context HttpServletRequest request) throws Exception {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)XMLWriter.writeXML((Object)this.catalogService.getCurrentCatalog(), StaticCatalog.class)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCatalogJson(@Context HttpServletRequest request) throws Exception {
        StaticCatalog catalog = this.catalogService.getCurrentCatalog();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)catalog).build();
    }

    @GET
    @Path(value="/availableAddons")
    @Produces(value={"application/json"})
    public Response getAvailableAddons(@QueryParam(value="baseProductName") String baseProductName, @Context HttpServletRequest request) throws CatalogApiException {
        StaticCatalog catalog = this.catalogService.getCurrentCatalog();
        List listings = catalog.getAvailableAddonListings(baseProductName);
        ArrayList<PlanDetailJson> details = new ArrayList<PlanDetailJson>();
        for (Listing listing : listings) {
            details.add(new PlanDetailJson(listing));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(details).build();
    }

    @GET
    @Path(value="/availableBasePlans")
    @Produces(value={"application/json"})
    public Response getAvailableBasePlans(@Context HttpServletRequest request) throws CatalogApiException {
        StaticCatalog catalog = this.catalogService.getCurrentCatalog();
        List listings = catalog.getAvailableBasePlanListings();
        ArrayList<PlanDetailJson> details = new ArrayList<PlanDetailJson>();
        for (Listing listing : listings) {
            details.add(new PlanDetailJson(listing));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(details).build();
    }

    @GET
    @Path(value="/simpleCatalog")
    @Produces(value={"application/json"})
    public Response getSimpleCatalog(@Context HttpServletRequest request) throws CatalogApiException {
        StaticCatalog catalog = this.catalogService.getCurrentCatalog();
        CatalogJsonSimple json = new CatalogJsonSimple(catalog);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }
}

