/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.resources;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentApi;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.jaxrs.json.AccountEmailJson;
import org.killbill.billing.jaxrs.json.AccountJson;
import org.killbill.billing.jaxrs.json.AccountTimelineJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.ChargebackJson;
import org.killbill.billing.jaxrs.json.CustomFieldJson;
import org.killbill.billing.jaxrs.json.InvoiceEmailJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.OverdueStateJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.PaymentMethodJson;
import org.killbill.billing.jaxrs.json.RefundJson;
import org.killbill.billing.jaxrs.resources.AuditMode;
import org.killbill.billing.jaxrs.resources.JaxRsResourceBase;
import org.killbill.billing.jaxrs.resources.PaymentMethodResource;
import org.killbill.billing.jaxrs.util.JaxrsUriBuilder;
import org.killbill.billing.overdue.OverdueApiException;
import org.killbill.billing.overdue.OverdueState;
import org.killbill.billing.overdue.OverdueUserApi;
import org.killbill.billing.overdue.config.api.OverdueException;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApi;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.Refund;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.clock.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Path(value="/1.0/kb/accounts")
public class AccountResource
extends JaxRsResourceBase {
    private static final String ID_PARAM_NAME = "accountId";
    private final SubscriptionApi subscriptionApi;
    private final InvoiceUserApi invoiceApi;
    private final InvoicePaymentApi invoicePaymentApi;
    private final PaymentApi paymentApi;
    private final OverdueUserApi overdueApi;

    @Inject
    public AccountResource(JaxrsUriBuilder uriBuilder, AccountUserApi accountApi, InvoiceUserApi invoiceApi, InvoicePaymentApi invoicePaymentApi, PaymentApi paymentApi, TagUserApi tagUserApi, AuditUserApi auditUserApi, CustomFieldUserApi customFieldUserApi, SubscriptionApi subscriptionApi, OverdueUserApi overdueApi, Clock clock, org.killbill.billing.jaxrs.util.Context context) {
        super(uriBuilder, tagUserApi, customFieldUserApi, auditUserApi, accountApi, clock, context);
        this.subscriptionApi = subscriptionApi;
        this.invoiceApi = invoiceApi;
        this.invoicePaymentApi = invoicePaymentApi;
        this.paymentApi = paymentApi;
        this.overdueApi = overdueApi;
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response getAccount(@PathParam(value="accountId") String accountId, @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        AccountJson accountJson = this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)accountJson).build();
    }

    @GET
    @Path(value="/pagination")
    @Produces(value={"application/json"})
    public Response getAccounts(@QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, final @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination accounts = this.accountUserApi.getAccounts(offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(AccountResource.class, "getAccounts", accounts.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"accountWithBalance", (Object)accountWithBalance.toString(), (Object)"accountWithBalanceAndCBA", (Object)accountWithBalanceAndCBA.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(accounts, new Function<Account, AccountJson>(){

            public AccountJson apply(Account account) {
                AccountAuditLogs accountAuditLogs = AccountResource.this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
                return AccountResource.this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/search/{searchKey:.*}")
    @Produces(value={"application/json"})
    public Response searchAccounts(@PathParam(value="searchKey") String searchKey, @QueryParam(value="offset") @DefaultValue(value="0") Long offset, @QueryParam(value="limit") @DefaultValue(value="100") Long limit, final @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, final @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, final @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException {
        final TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Pagination accounts = this.accountUserApi.searchAccounts(searchKey, offset, limit, tenantContext);
        URI nextPageUri = this.uriBuilder.nextPage(AccountResource.class, "searchAccounts", accounts.getNextOffset(), limit, (Map<String, String>)ImmutableMap.of((Object)"searchKey", (Object)searchKey, (Object)"accountWithBalance", (Object)accountWithBalance.toString(), (Object)"accountWithBalanceAndCBA", (Object)accountWithBalanceAndCBA.toString(), (Object)"audit", (Object)auditMode.getLevel().toString()));
        return this.buildStreamingPaginationResponse(accounts, new Function<Account, AccountJson>(){

            public AccountJson apply(Account account) {
                AccountAuditLogs accountAuditLogs = AccountResource.this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
                return AccountResource.this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
            }
        }, nextPageUri);
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/bundles")
    @Produces(value={"application/json"})
    public Response getAccountBundles(@PathParam(value="accountId") String accountId, @QueryParam(value="externalKey") String externalKey, @Context HttpServletRequest request) throws AccountApiException, SubscriptionApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        UUID uuid = UUID.fromString(accountId);
        this.accountUserApi.getAccountById(uuid, tenantContext);
        List bundles = externalKey != null ? this.subscriptionApi.getSubscriptionBundlesForAccountIdAndExternalKey(uuid, externalKey, tenantContext) : this.subscriptionApi.getSubscriptionBundlesForAccountId(uuid, tenantContext);
        Collection result = Collections2.transform((Collection)bundles, (Function)new Function<SubscriptionBundle, BundleJson>(){

            public BundleJson apply(SubscriptionBundle input) {
                return new BundleJson(input, null);
            }
        });
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAccountByKey(@QueryParam(value="externalKey") String externalKey, @QueryParam(value="accountWithBalance") @DefaultValue(value="false") Boolean accountWithBalance, @QueryParam(value="accountWithBalanceAndCBA") @DefaultValue(value="false") Boolean accountWithBalanceAndCBA, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountByKey(externalKey, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        AccountJson accountJson = this.getAccount(account, accountWithBalance, accountWithBalanceAndCBA, accountAuditLogs, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)accountJson).build();
    }

    private AccountJson getAccount(Account account, Boolean accountWithBalance, Boolean accountWithBalanceAndCBA, AccountAuditLogs auditLogs, TenantContext tenantContext) {
        if (accountWithBalanceAndCBA.booleanValue()) {
            BigDecimal accountBalance = this.invoiceApi.getAccountBalance(account.getId(), tenantContext);
            BigDecimal accountCBA = this.invoiceApi.getAccountCBA(account.getId(), tenantContext);
            return new AccountJson(account, accountBalance, accountCBA, auditLogs);
        }
        if (accountWithBalance.booleanValue()) {
            BigDecimal accountBalance = this.invoiceApi.getAccountBalance(account.getId(), tenantContext);
            return new AccountJson(account, accountBalance, null, auditLogs);
        }
        return new AccountJson(account, null, null, auditLogs);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAccount(AccountJson json, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws AccountApiException {
        AccountData data = json.toAccountData();
        Account account = this.accountUserApi.createAccount(data, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getAccount", account.getId());
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    public Response updateAccount(AccountJson json, @PathParam(value="accountId") String accountId, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws AccountApiException {
        AccountData data = json.toAccountData();
        UUID uuid = UUID.fromString(accountId);
        this.accountUserApi.updateAccount(uuid, data, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        return this.getAccount(accountId, (Boolean)false, (Boolean)false, new AuditMode(AuditLevel.NONE.toString()), request);
    }

    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}")
    @Produces(value={"application/json"})
    public Response cancelAccount(@PathParam(value="accountId") String accountId, @Context HttpServletRequest request) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/timeline")
    @Produces(value={"application/json"})
    public Response getAccountTimeline(@PathParam(value="accountId") String accountIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException, SubscriptionApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        UUID accountId = UUID.fromString(accountIdString);
        Account account = this.accountUserApi.getAccountById(accountId, tenantContext);
        List invoices = this.invoiceApi.getInvoicesByAccount(account.getId(), tenantContext);
        List payments = this.paymentApi.getAccountPayments(accountId, tenantContext);
        List refunds = this.paymentApi.getAccountRefunds(account, tenantContext);
        ArrayListMultimap refundsByPayment = ArrayListMultimap.create();
        for (Refund refund : refunds) {
            refundsByPayment.put((Object)refund.getPaymentId(), (Object)refund);
        }
        List chargebacks = this.invoicePaymentApi.getChargebacksByAccountId(accountId, tenantContext);
        ArrayListMultimap chargebacksByPayment = ArrayListMultimap.create();
        for (InvoicePayment chargeback : chargebacks) {
            chargebacksByPayment.put((Object)chargeback.getPaymentId(), (Object)chargeback);
        }
        List bundles = this.subscriptionApi.getSubscriptionBundlesForAccountId(account.getId(), tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        AccountTimelineJson json = new AccountTimelineJson(account, invoices, payments, bundles, (Multimap<UUID, Refund>)refundsByPayment, (Multimap<UUID, InvoicePayment>)chargebacksByPayment, accountAuditLogs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)json).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emailNotifications")
    @Produces(value={"application/json"})
    public Response getEmailNotificationsForAccount(@PathParam(value="accountId") String accountId, @Context HttpServletRequest request) throws AccountApiException {
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), this.context.createContext((ServletRequest)request));
        InvoiceEmailJson invoiceEmailJson = new InvoiceEmailJson(accountId, account.isNotifiedForInvoices());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)invoiceEmailJson).build();
    }

    @PUT
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emailNotifications")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getEmailNotificationsForAccount(InvoiceEmailJson json, @PathParam(value="accountId") String accountIdString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(accountIdString);
        Account account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        MutableAccountData mutableAccountData = account.toMutableAccountData();
        mutableAccountData.setIsNotifiedForInvoices(json.isNotifiedForInvoices());
        this.accountUserApi.updateAccount(accountId, (AccountData)mutableAccountData, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/cbaRebalancing")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response rebalanceExistingCBAOnAccount(@PathParam(value="accountId") String accountIdString, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(accountIdString);
        this.invoiceApi.consumeExstingCBAOnAccountWithUnpaidInvoices(accountId, callContext);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/invoices")
    @Produces(value={"application/json"})
    public Response getInvoices(@PathParam(value="accountId") String accountIdString, @QueryParam(value="withItems") @DefaultValue(value="false") boolean withItems, @QueryParam(value="unpaidInvoicesOnly") @DefaultValue(value="false") boolean unpaidInvoicesOnly, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        UUID accountId = UUID.fromString(accountIdString);
        this.accountUserApi.getAccountById(accountId, tenantContext);
        List invoices = unpaidInvoicesOnly ? new ArrayList(this.invoiceApi.getUnpaidInvoicesByAccountId(accountId, null, tenantContext)) : this.invoiceApi.getInvoicesByAccount(accountId, tenantContext);
        AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(accountId, auditMode.getLevel(), tenantContext);
        LinkedList<InvoiceJson> result = new LinkedList<InvoiceJson>();
        for (Invoice invoice : invoices) {
            result.add(new InvoiceJson(invoice, withItems, accountAuditLogs));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    @Produces(value={"application/json"})
    public Response getPayments(@PathParam(value="accountId") String accountId, @Context HttpServletRequest request) throws PaymentApiException {
        List payments = this.paymentApi.getAccountPayments(UUID.fromString(accountId), this.context.createContext((ServletRequest)request));
        ArrayList<PaymentJson> result = new ArrayList<PaymentJson>(payments.size());
        for (Payment payment : payments) {
            result.add(new PaymentJson(payment, null));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/payments")
    public Response payAllInvoices(@PathParam(value="accountId") String accountId, @QueryParam(value="externalPayment") @DefaultValue(value="false") Boolean externalPayment, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        Collection unpaidInvoices = this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), this.clock.getUTCToday(), (TenantContext)callContext);
        for (Invoice invoice : unpaidInvoices) {
            if (externalPayment.booleanValue()) {
                this.paymentApi.createExternalPayment(account, invoice.getId(), invoice.getBalance(), callContext);
                continue;
            }
            this.paymentApi.createPayment(account, invoice.getId(), invoice.getBalance(), callContext);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPaymentMethod(PaymentMethodJson json, @PathParam(value="accountId") String accountId, @QueryParam(value="isDefault") @DefaultValue(value="false") Boolean isDefault, @QueryParam(value="payAllUnpaidInvoices") @DefaultValue(value="false") Boolean payAllUnpaidInvoices, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        List<Invoice> unpaidInvoices;
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        PaymentMethod data = json.toPaymentMethod(accountId);
        Account account = this.accountUserApi.getAccountById(data.getAccountId(), (TenantContext)callContext);
        boolean hasDefaultPaymentMethod = account.getPaymentMethodId() != null || isDefault != false;
        Collection<Object> collection = unpaidInvoices = payAllUnpaidInvoices != false ? this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), this.clock.getUTCToday(), (TenantContext)callContext) : Collections.emptyList();
        if (payAllUnpaidInvoices.booleanValue() && unpaidInvoices.size() > 0 && !hasDefaultPaymentMethod) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        UUID paymentMethodId = this.paymentApi.addPaymentMethod(data.getPluginName(), account, isDefault.booleanValue(), data.getPluginDetail(), callContext);
        if (payAllUnpaidInvoices.booleanValue() && unpaidInvoices.size() > 0) {
            for (Invoice invoice : unpaidInvoices) {
                this.paymentApi.createPayment(account, invoice.getId(), invoice.getBalance(), callContext);
            }
        }
        return this.uriBuilder.buildResponse(PaymentMethodResource.class, "getPaymentMethod", paymentMethodId, uriInfo.getBaseUri().toString());
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods")
    @Produces(value={"application/json"})
    public Response getPaymentMethods(@PathParam(value="accountId") String accountId, @QueryParam(value="withPluginInfo") @DefaultValue(value="false") Boolean withPluginInfo, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        final Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), tenantContext);
        List methods = this.paymentApi.getPaymentMethods(account, withPluginInfo.booleanValue(), tenantContext);
        final AccountAuditLogs accountAuditLogs = this.auditUserApi.getAccountAuditLogs(account.getId(), auditMode.getLevel(), tenantContext);
        ArrayList json = new ArrayList(Collections2.transform((Collection)methods, (Function)new Function<PaymentMethod, PaymentMethodJson>(){

            public PaymentMethodJson apply(PaymentMethod input) {
                return PaymentMethodJson.toPaymentMethodJson(account, input, accountAuditLogs);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity(json).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/paymentMethods/{paymentMethodId:\\w+-\\w+-\\w+-\\w+-\\w+}/setDefault")
    public Response setDefaultPaymentMethod(@PathParam(value="accountId") String accountId, @PathParam(value="paymentMethodId") String paymentMethodId, @QueryParam(value="payAllUnpaidInvoices") @DefaultValue(value="false") Boolean payAllUnpaidInvoices, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), (TenantContext)callContext);
        this.paymentApi.setDefaultPaymentMethod(account, UUID.fromString(paymentMethodId), callContext);
        if (payAllUnpaidInvoices.booleanValue()) {
            Collection unpaidInvoices = this.invoiceApi.getUnpaidInvoicesByAccountId(account.getId(), this.clock.getUTCToday(), (TenantContext)callContext);
            for (Invoice invoice : unpaidInvoices) {
                this.paymentApi.createPayment(account, invoice.getId(), invoice.getBalance(), callContext);
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/chargebacks")
    @Produces(value={"application/json"})
    public Response getChargebacksForAccount(@PathParam(value="accountId") String accountIdStr, @Context HttpServletRequest request) {
        UUID accountId = UUID.fromString(accountIdStr);
        List chargebacks = this.invoicePaymentApi.getChargebacksByAccountId(accountId, this.context.createContext((ServletRequest)request));
        ArrayList<ChargebackJson> chargebacksJson = new ArrayList<ChargebackJson>();
        for (InvoicePayment chargeback : chargebacks) {
            chargebacksJson.add(new ChargebackJson(accountId, chargeback));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(chargebacksJson).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/refunds")
    @Produces(value={"application/json"})
    public Response getRefunds(@PathParam(value="accountId") String accountId, @Context HttpServletRequest request) throws AccountApiException, PaymentApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), tenantContext);
        List refunds = this.paymentApi.getAccountRefunds(account, tenantContext);
        ArrayList result = new ArrayList(Collections2.transform((Collection)refunds, (Function)new Function<Refund, RefundJson>(){

            public RefundJson apply(Refund input) {
                return new RefundJson(input, null, null);
            }
        }));
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/overdue")
    @Produces(value={"application/json"})
    public Response getOverdueAccount(@PathParam(value="accountId") String accountId, @Context HttpServletRequest request) throws AccountApiException, OverdueException, OverdueApiException {
        TenantContext tenantContext = this.context.createContext((ServletRequest)request);
        Account account = this.accountUserApi.getAccountById(UUID.fromString(accountId), tenantContext);
        OverdueState overdueState = this.overdueApi.getOverdueStateFor(account, tenantContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new OverdueStateJson(overdueState)).build();
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Produces(value={"application/json"})
    public Response getCustomFields(@PathParam(value="accountId") String id, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @Context HttpServletRequest request) {
        return super.getCustomFields(UUID.fromString(id), auditMode, this.context.createContext((ServletRequest)request));
    }

    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createCustomFields(@PathParam(value="accountId") String id, List<CustomFieldJson> customFields, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws CustomFieldApiException {
        return super.createCustomFields(UUID.fromString(id), customFields, this.context.createContext(createdBy, reason, comment, (ServletRequest)request), uriInfo);
    }

    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/customFields")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteCustomFields(@PathParam(value="accountId") String id, @QueryParam(value="customFieldList") String customFieldList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws CustomFieldApiException {
        return super.deleteCustomFields(UUID.fromString(id), customFieldList, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    public Response getTags(@PathParam(value="accountId") String accountIdString, @QueryParam(value="audit") @DefaultValue(value="NONE") AuditMode auditMode, @QueryParam(value="includedDeleted") @DefaultValue(value="false") Boolean includedDeleted, @Context HttpServletRequest request) throws TagDefinitionApiException {
        UUID accountId = UUID.fromString(accountIdString);
        return super.getTags(accountId, accountId, auditMode, includedDeleted, this.context.createContext((ServletRequest)request));
    }

    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Produces(value={"application/json"})
    public Response createTags(@PathParam(value="accountId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws TagApiException {
        return super.createTags(UUID.fromString(id), tagList, uriInfo, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
    }

    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteTags(@PathParam(value="accountId") String id, @QueryParam(value="tagList") String tagList, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) throws TagApiException, AccountApiException {
        Account account;
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        Collection<UUID> tagDefinitionUUIDs = this.getTagDefinitionUUIDs(tagList);
        boolean isTagAutoPayOff = false;
        for (UUID cur : tagDefinitionUUIDs) {
            if (!cur.equals(ControlTagType.AUTO_PAY_OFF.getId())) continue;
            isTagAutoPayOff = true;
            break;
        }
        UUID accountId = UUID.fromString(id);
        if (isTagAutoPayOff && (account = this.accountUserApi.getAccountById(accountId, (TenantContext)callContext)).getPaymentMethodId() == null) {
            throw new TagApiException(ErrorCode.TAG_CANNOT_BE_REMOVED, new Object[]{ControlTagType.AUTO_PAY_OFF, " the account does not have a default payment method"});
        }
        return super.deleteTags(UUID.fromString(id), tagList, callContext);
    }

    @GET
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails")
    @Produces(value={"application/json"})
    public Response getEmails(@PathParam(value="accountId") String id, @Context HttpServletRequest request) {
        UUID accountId = UUID.fromString(id);
        List emails = this.accountUserApi.getEmails(accountId, this.context.createContext((ServletRequest)request));
        ArrayList<AccountEmailJson> emailsJson = new ArrayList<AccountEmailJson>();
        for (AccountEmail email : emails) {
            emailsJson.add(new AccountEmailJson(email.getAccountId().toString(), email.getEmail()));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(emailsJson).build();
    }

    @POST
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addEmail(final AccountEmailJson json, @PathParam(value="accountId") String id, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request, @Context UriInfo uriInfo) throws AccountApiException {
        CallContext callContext = this.context.createContext(createdBy, reason, comment, (ServletRequest)request);
        UUID accountId = UUID.fromString(id);
        this.accountUserApi.getAccountById(accountId, (TenantContext)callContext);
        AccountEmail existingEmail = (AccountEmail)Iterables.tryFind((Iterable)this.accountUserApi.getEmails(accountId, (TenantContext)callContext), (Predicate)new Predicate<AccountEmail>(){

            public boolean apply(AccountEmail input) {
                return input.getEmail().equals(json.getEmail());
            }
        }).orNull();
        if (existingEmail == null) {
            this.accountUserApi.addEmail(accountId, json.toAccountEmail(UUID.randomUUID()), callContext);
        }
        return this.uriBuilder.buildResponse(uriInfo, AccountResource.class, "getEmails", (Object)json.getAccountId());
    }

    @DELETE
    @Path(value="/{accountId:\\w+-\\w+-\\w+-\\w+-\\w+}/emails/{email}")
    @Produces(value={"application/json"})
    public Response removeEmail(@PathParam(value="accountId") String id, @PathParam(value="email") String email, @HeaderParam(value="X-Killbill-CreatedBy") String createdBy, @HeaderParam(value="X-Killbill-Reason") String reason, @HeaderParam(value="X-Killbill-Comment") String comment, @Context HttpServletRequest request) {
        UUID accountId = UUID.fromString(id);
        List emails = this.accountUserApi.getEmails(accountId, this.context.createContext((ServletRequest)request));
        for (AccountEmail cur : emails) {
            if (!cur.getEmail().equals(email)) continue;
            AccountEmailJson accountEmailJson = new AccountEmailJson(accountId.toString(), email);
            AccountEmail accountEmail = accountEmailJson.toAccountEmail(cur.getId());
            this.accountUserApi.removeEmail(accountId, accountEmail, this.context.createContext(createdBy, reason, comment, (ServletRequest)request));
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ACCOUNT;
    }
}

