/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.mappers;

import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.killbill.billing.jaxrs.mappers.ExceptionMapperBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Provider
public class RuntimeExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<RuntimeException> {
    private final UriInfo uriInfo;
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionMapper.class);

    public RuntimeExceptionMapper(@Context UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Response toResponse(RuntimeException exception) {
        if (exception instanceof NullPointerException) {
            exception.printStackTrace();
            log.warn("Exception : " + exception.getMessage());
            return this.buildBadRequestResponse(exception, this.uriInfo);
        }
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        return this.buildInternalErrorResponse(exception, this.uriInfo);
    }
}

