/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.killbill.billing.usage.api.RolledUpUsage;

public class UsageJson {
    private final String subscriptionId;
    private final String unitType;
    private final DateTime startTime;
    private final DateTime endTime;
    private final BigDecimal amount;

    @JsonCreator
    public UsageJson(@JsonProperty(value="subscriptionId") String subscriptionId, @JsonProperty(value="unitType") String unitType, @JsonProperty(value="startTime") DateTime startTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="amount") BigDecimal amount) {
        this.subscriptionId = subscriptionId;
        this.unitType = unitType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.amount = amount;
    }

    public UsageJson(RolledUpUsage usage) {
        this(usage.getSubscriptionId().toString(), usage.getUnitType(), usage.getStartTime(), usage.getEndTime(), usage.getAmount());
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UsageJson)) {
            return false;
        }
        UsageJson usageJson = (UsageJson)o;
        if (this.amount != null ? !this.amount.equals(usageJson.amount) : usageJson.amount != null) {
            return false;
        }
        if (this.endTime != null ? !this.endTime.equals((Object)usageJson.endTime) : usageJson.endTime != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals((Object)usageJson.startTime) : usageJson.startTime != null) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(usageJson.subscriptionId) : usageJson.subscriptionId != null) {
            return false;
        }
        return !(this.unitType != null ? !this.unitType.equals(usageJson.unitType) : usageJson.unitType != null);
    }

    public int hashCode() {
        int result = this.subscriptionId != null ? this.subscriptionId.hashCode() : 0;
        result = 31 * result + (this.unitType != null ? this.unitType.hashCode() : 0);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        return result;
    }
}

