/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionJson
extends JsonBase {
    private final String accountId;
    private final String bundleId;
    private final String subscriptionId;
    private final String externalKey;
    private final LocalDate startDate;
    private final String productName;
    private final String productCategory;
    private final String billingPeriod;
    private final String priceList;
    private final LocalDate cancelledDate;
    private final LocalDate chargedThroughDate;
    private final LocalDate billingStartDate;
    private final LocalDate billingEndDate;
    private final List<EventSubscriptionJson> events;
    private final List<DeletedEventSubscriptionJson> deletedEvents;
    private final List<NewEventSubscriptionJson> newEvents;

    @JsonCreator
    public SubscriptionJson(@JsonProperty(value="accountId") @Nullable String accountId, @JsonProperty(value="bundleId") @Nullable String bundleId, @JsonProperty(value="subscriptionId") @Nullable String subscriptionId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="startDate") @Nullable LocalDate startDate, @JsonProperty(value="productName") @Nullable String productName, @JsonProperty(value="productCategory") @Nullable String productCategory, @JsonProperty(value="billingPeriod") @Nullable String billingPeriod, @JsonProperty(value="priceList") @Nullable String priceList, @JsonProperty(value="cancelledDate") @Nullable LocalDate cancelledDate, @JsonProperty(value="chargedThroughDate") @Nullable LocalDate chargedThroughDate, @JsonProperty(value="billingStartDate") @Nullable LocalDate billingStartDate, @JsonProperty(value="billingEndDate") @Nullable LocalDate billingEndDate, @JsonProperty(value="events") @Nullable List<EventSubscriptionJson> events, @JsonProperty(value="newEvents") @Nullable List<NewEventSubscriptionJson> newEvents, @JsonProperty(value="deletedEvents") @Nullable List<DeletedEventSubscriptionJson> deletedEvents, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.startDate = startDate;
        this.productName = productName;
        this.productCategory = productCategory;
        this.billingPeriod = billingPeriod;
        this.priceList = priceList;
        this.cancelledDate = cancelledDate;
        this.chargedThroughDate = chargedThroughDate;
        this.billingStartDate = billingStartDate;
        this.billingEndDate = billingEndDate;
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.subscriptionId = subscriptionId;
        this.externalKey = externalKey;
        this.events = events;
        this.deletedEvents = deletedEvents;
        this.newEvents = newEvents;
    }

    public SubscriptionJson(Subscription subscription, List<SubscriptionEvent> subscriptionEvents, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)SubscriptionJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForSubscription(subscription.getId())));
        this.startDate = subscription.getEffectiveStartDate();
        this.productName = subscription.getLastActiveProduct().getName();
        this.productCategory = subscription.getLastActiveProductCategory().name();
        this.billingPeriod = subscription.getLastActivePlan().getRecurringBillingPeriod().toString();
        this.priceList = subscription.getLastActivePriceList().getName();
        this.cancelledDate = subscription.getEffectiveEndDate();
        this.chargedThroughDate = subscription.getChargedThroughDate();
        this.billingStartDate = subscription.getBillingStartDate();
        this.billingEndDate = subscription.getBillingEndDate();
        this.accountId = subscription.getAccountId().toString();
        this.bundleId = subscription.getBundleId().toString();
        this.subscriptionId = subscription.getId().toString();
        this.externalKey = subscription.getExternalKey();
        LinkedList linkedList = this.events = subscriptionEvents != null ? new LinkedList() : null;
        if (this.events != null) {
            for (SubscriptionEvent cur : subscriptionEvents) {
                BillingPeriod billingPeriod = cur.getNextBillingPeriod() != null ? cur.getNextBillingPeriod() : cur.getPrevBillingPeriod();
                Product product = cur.getNextProduct() != null ? cur.getNextProduct() : cur.getPrevProduct();
                PriceList priceList = cur.getNextPriceList() != null ? cur.getNextPriceList() : cur.getPrevPriceList();
                PlanPhase phase = cur.getNextPhase() != null ? cur.getNextPhase() : cur.getPrevPhase();
                this.events.add(new EventSubscriptionJson(cur.getId().toString(), billingPeriod != null ? billingPeriod.toString() : null, cur.getRequestedDate(), cur.getEffectiveDate(), product != null ? product.getName() : null, priceList != null ? priceList.getName() : null, cur.getSubscriptionEventType().toString(), phase != null ? phase.getName() : null, (List<AuditLogJson>)SubscriptionJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForSubscriptionEvent(cur.getId()))));
            }
        }
        this.newEvents = null;
        this.deletedEvents = null;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductCategory() {
        return this.productCategory;
    }

    public String getBillingPeriod() {
        return this.billingPeriod;
    }

    public String getPriceList() {
        return this.priceList;
    }

    public LocalDate getCancelledDate() {
        return this.cancelledDate;
    }

    public LocalDate getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public LocalDate getBillingStartDate() {
        return this.billingStartDate;
    }

    public LocalDate getBillingEndDate() {
        return this.billingEndDate;
    }

    public List<EventSubscriptionJson> getEvents() {
        return this.events;
    }

    public List<DeletedEventSubscriptionJson> getDeletedEvents() {
        return this.deletedEvents;
    }

    public List<NewEventSubscriptionJson> getNewEvents() {
        return this.newEvents;
    }

    public String toString() {
        return "SubscriptionJson{accountId='" + this.accountId + '\'' + ", bundleId='" + this.bundleId + '\'' + ", subscriptionId='" + this.subscriptionId + '\'' + ", externalKey='" + this.externalKey + '\'' + ", startDate=" + this.startDate + ", productName='" + this.productName + '\'' + ", productCategory='" + this.productCategory + '\'' + ", billingPeriod='" + this.billingPeriod + '\'' + ", priceList='" + this.priceList + '\'' + ", cancelledDate=" + this.cancelledDate + ", chargedThroughDate=" + this.chargedThroughDate + ", billingStartDate=" + this.billingStartDate + ", billingEndDate=" + this.billingEndDate + ", events=" + this.events + ", deletedEvents=" + this.deletedEvents + ", newEvents=" + this.newEvents + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionJson that = (SubscriptionJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.billingEndDate != null ? this.billingEndDate.compareTo((ReadablePartial)that.billingEndDate) != 0 : that.billingEndDate != null) {
            return false;
        }
        if (this.billingPeriod != null ? !this.billingPeriod.equals(that.billingPeriod) : that.billingPeriod != null) {
            return false;
        }
        if (this.billingStartDate != null ? this.billingStartDate.compareTo((ReadablePartial)that.billingStartDate) != 0 : that.billingStartDate != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.cancelledDate != null ? this.cancelledDate.compareTo((ReadablePartial)that.cancelledDate) != 0 : that.cancelledDate != null) {
            return false;
        }
        if (this.chargedThroughDate != null ? this.chargedThroughDate.compareTo((ReadablePartial)that.chargedThroughDate) != 0 : that.chargedThroughDate != null) {
            return false;
        }
        if (this.deletedEvents != null ? !this.deletedEvents.equals(that.deletedEvents) : that.deletedEvents != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(that.events) : that.events != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.newEvents != null ? !this.newEvents.equals(that.newEvents) : that.newEvents != null) {
            return false;
        }
        if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
            return false;
        }
        if (this.productCategory != null ? !this.productCategory.equals(that.productCategory) : that.productCategory != null) {
            return false;
        }
        if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) {
            return false;
        }
        if (this.startDate != null ? this.startDate.compareTo((ReadablePartial)that.startDate) != 0 : that.startDate != null) {
            return false;
        }
        return !(this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
        result = 31 * result + (this.productCategory != null ? this.productCategory.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
        result = 31 * result + (this.cancelledDate != null ? this.cancelledDate.hashCode() : 0);
        result = 31 * result + (this.chargedThroughDate != null ? this.chargedThroughDate.hashCode() : 0);
        result = 31 * result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
        result = 31 * result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.deletedEvents != null ? this.deletedEvents.hashCode() : 0);
        result = 31 * result + (this.newEvents != null ? this.newEvents.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class EventBaseSubscriptionJson
    extends JsonBase {
        private final String billingPeriod;
        private final LocalDate requestedDate;
        private final String product;
        private final String priceList;
        private final String eventType;
        private final String phase;

        @JsonCreator
        public EventBaseSubscriptionJson(@JsonProperty(value="billingPeriod") String billingPeriod, @JsonProperty(value="requestedDate") LocalDate requestedDate, @JsonProperty(value="product") String product, @JsonProperty(value="priceList") String priceList, @JsonProperty(value="eventType") String eventType, @JsonProperty(value="phase") String phase, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
            super(auditLogs);
            this.billingPeriod = billingPeriod;
            this.requestedDate = requestedDate;
            this.product = product;
            this.priceList = priceList;
            this.eventType = eventType;
            this.phase = phase;
        }

        public String getBillingPeriod() {
            return this.billingPeriod;
        }

        public LocalDate getRequestedDate() {
            return this.requestedDate;
        }

        public String getProduct() {
            return this.product;
        }

        public String getPriceList() {
            return this.priceList;
        }

        public String getEventType() {
            return this.eventType;
        }

        public String getPhase() {
            return this.phase;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("EventBaseSubscriptionJson");
            sb.append("{billingPeriod='").append(this.billingPeriod).append('\'');
            sb.append(", requestedDate=").append(this.requestedDate);
            sb.append(", product='").append(this.product).append('\'');
            sb.append(", priceList='").append(this.priceList).append('\'');
            sb.append(", eventType='").append(this.eventType).append('\'');
            sb.append(", phase='").append(this.phase).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventBaseSubscriptionJson that = (EventBaseSubscriptionJson)o;
            if (this.billingPeriod != null ? !this.billingPeriod.equals(that.billingPeriod) : that.billingPeriod != null) {
                return false;
            }
            if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) {
                return false;
            }
            if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
                return false;
            }
            if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
                return false;
            }
            if (this.product != null ? !this.product.equals(that.product) : that.product != null) {
                return false;
            }
            return !(this.requestedDate != null ? !this.requestedDate.equals((Object)that.requestedDate) : that.requestedDate != null);
        }

        public int hashCode() {
            int result = this.billingPeriod != null ? this.billingPeriod.hashCode() : 0;
            result = 31 * result + (this.requestedDate != null ? this.requestedDate.hashCode() : 0);
            result = 31 * result + (this.product != null ? this.product.hashCode() : 0);
            result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
            result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
            result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewEventSubscriptionJson
    extends EventBaseSubscriptionJson {
        @JsonCreator
        public NewEventSubscriptionJson(@JsonProperty(value="billingPeriod") String billingPeriod, @JsonProperty(value="requestedDate") LocalDate requestedDate, @JsonProperty(value="product") String product, @JsonProperty(value="priceList") String priceList, @JsonProperty(value="eventType") String eventType, @JsonProperty(value="phase") String phase, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
            super(billingPeriod, requestedDate, product, priceList, eventType, phase, auditLogs);
        }

        @Override
        public String toString() {
            return "NewEventSubscriptionJson [getBillingPeriod()=" + this.getBillingPeriod() + ", getRequestedDate()=" + this.getRequestedDate() + ", getProduct()=" + this.getProduct() + ", getPriceList()=" + this.getPriceList() + ", getEventType()=" + this.getEventType() + ", getPhase()=" + this.getPhase() + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeletedEventSubscriptionJson
    extends EventSubscriptionJson {
        @JsonCreator
        public DeletedEventSubscriptionJson(@JsonProperty(value="eventId") String eventId, @JsonProperty(value="billingPeriod") String billingPeriod, @JsonProperty(value="requestedDate") LocalDate requestedDate, @JsonProperty(value="effectiveDate") LocalDate effectiveDate, @JsonProperty(value="product") String product, @JsonProperty(value="priceList") String priceList, @JsonProperty(value="eventType") String eventType, @JsonProperty(value="phase") String phase, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
            super(eventId, billingPeriod, requestedDate, effectiveDate, product, priceList, eventType, phase, auditLogs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventSubscriptionJson
    extends EventBaseSubscriptionJson {
        private final String eventId;
        private final LocalDate effectiveDate;

        @JsonCreator
        public EventSubscriptionJson(@JsonProperty(value="eventId") String eventId, @JsonProperty(value="billingPeriod") String billingPeriod, @JsonProperty(value="requestedDt") LocalDate requestedDate, @JsonProperty(value="effectiveDt") LocalDate effectiveDate, @JsonProperty(value="product") String product, @JsonProperty(value="priceList") String priceList, @JsonProperty(value="eventType") String eventType, @JsonProperty(value="phase") String phase, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
            super(billingPeriod, requestedDate, product, priceList, eventType, phase, auditLogs);
            this.eventId = eventId;
            this.effectiveDate = effectiveDate;
        }

        public String getEventId() {
            return this.eventId;
        }

        public LocalDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public String toString() {
            return "EventSubscriptionJson [eventId=" + this.eventId + ", effectiveDate=" + this.effectiveDate + ", getBillingPeriod()=" + this.getBillingPeriod() + ", getRequestedDate()=" + this.getRequestedDate() + ", getProduct()=" + this.getProduct() + ", getPriceList()=" + this.getPriceList() + ", getEventType()=" + this.getEventType() + ", getPhase()=" + this.getPhase() + ", getClass()=" + this.getClass() + ", hashCode()=" + this.hashCode() + ", toString()=" + super.toString() + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventSubscriptionJson that = (EventSubscriptionJson)o;
            if (this.effectiveDate != null ? !this.effectiveDate.equals((Object)that.effectiveDate) : that.effectiveDate != null) {
                return false;
            }
            return !(this.eventId != null ? !this.eventId.equals(that.eventId) : that.eventId != null);
        }

        @Override
        public int hashCode() {
            int result = this.eventId != null ? this.eventId.hashCode() : 0;
            result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            return result;
        }
    }
}

