/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.killbill.billing.jaxrs.json.SessionJson;

public class SubjectJson {
    private final String principal;
    private final Boolean isAuthenticated;
    private final Boolean isRemembered;
    private final SessionJson session;

    @JsonCreator
    public SubjectJson(@JsonProperty(value="principal") String principal, @JsonProperty(value="isAuthenticated") Boolean isAuthenticated, @JsonProperty(value="isRemembered") Boolean isRemembered, @JsonProperty(value="session") @Nullable SessionJson session) {
        this.principal = principal;
        this.isAuthenticated = isAuthenticated;
        this.isRemembered = isRemembered;
        this.session = session;
    }

    public SubjectJson(Subject subject) {
        this.principal = subject.getPrincipal() == null ? null : subject.getPrincipal().toString();
        this.isAuthenticated = subject.isAuthenticated();
        this.isRemembered = subject.isRemembered();
        Session subjectSession = subject.getSession(false);
        this.session = subjectSession == null ? null : new SessionJson(subjectSession);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Boolean getIsAuthenticated() {
        return this.isAuthenticated;
    }

    public Boolean getIsRemembered() {
        return this.isRemembered;
    }

    public SessionJson getSession() {
        return this.session;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SubjectJson{");
        sb.append("principal='").append(this.principal).append('\'');
        sb.append(", isAuthenticated=").append(this.isAuthenticated);
        sb.append(", isRemembered=").append(this.isRemembered);
        sb.append(", session=").append(this.session);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectJson that = (SubjectJson)o;
        if (this.isAuthenticated != null ? !this.isAuthenticated.equals(that.isAuthenticated) : that.isAuthenticated != null) {
            return false;
        }
        if (this.isRemembered != null ? !this.isRemembered.equals(that.isRemembered) : that.isRemembered != null) {
            return false;
        }
        if (this.principal != null ? !this.principal.equals(that.principal) : that.principal != null) {
            return false;
        }
        return !(this.session != null ? !this.session.equals(that.session) : that.session != null);
    }

    public int hashCode() {
        int result = this.principal != null ? this.principal.hashCode() : 0;
        result = 31 * result + (this.isAuthenticated != null ? this.isAuthenticated.hashCode() : 0);
        result = 31 * result + (this.isRemembered != null ? this.isRemembered.hashCode() : 0);
        result = 31 * result + (this.session != null ? this.session.hashCode() : 0);
        return result;
    }
}

