/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.InvoiceItemJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.payment.api.Refund;
import org.killbill.billing.util.audit.AuditLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefundJson
extends JsonBase {
    private final String refundId;
    private final String paymentId;
    private final BigDecimal amount;
    private final String currency;
    private final Boolean isAdjusted;
    private final DateTime requestedDate;
    private final DateTime effectiveDate;
    private final String status;
    private final List<InvoiceItemJson> adjustments;

    @JsonCreator
    public RefundJson(@JsonProperty(value="refundId") String refundId, @JsonProperty(value="paymentId") String paymentId, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") String currency, @JsonProperty(value="status") String status, @JsonProperty(value="adjusted") Boolean isAdjusted, @JsonProperty(value="requestedDate") DateTime requestedDate, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="adjustments") @Nullable List<InvoiceItemJson> adjustments, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.refundId = refundId;
        this.paymentId = paymentId;
        this.amount = amount;
        this.currency = currency;
        this.status = status;
        this.isAdjusted = isAdjusted;
        this.requestedDate = requestedDate;
        this.effectiveDate = effectiveDate;
        this.adjustments = adjustments;
    }

    public RefundJson(Refund refund) {
        this(refund, null, null);
    }

    public RefundJson(Refund refund, @Nullable List<InvoiceItem> adjustments, @Nullable List<AuditLog> auditLogs) {
        this(refund.getId().toString(), refund.getPaymentId().toString(), refund.getRefundAmount(), refund.getCurrency().toString(), refund.getRefundStatus().toString(), refund.isAdjusted(), refund.getEffectiveDate(), refund.getEffectiveDate(), (List<InvoiceItemJson>)(adjustments == null ? null : ImmutableList.copyOf((Collection)Collections2.transform(adjustments, (Function)new Function<InvoiceItem, InvoiceItemJson>(){

            public InvoiceItemJson apply(@Nullable InvoiceItem input) {
                return new InvoiceItemJson(input);
            }
        }))), (List<AuditLogJson>)RefundJson.toAuditLogJson(auditLogs));
    }

    public String getRefundId() {
        return this.refundId;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean isAdjusted() {
        return this.isAdjusted;
    }

    public DateTime getRequestedDate() {
        return this.requestedDate;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public List<InvoiceItemJson> getAdjustments() {
        return this.adjustments;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RefundJson");
        sb.append("{refundId='").append(this.refundId).append('\'');
        sb.append(", paymentId='").append(this.paymentId).append('\'');
        sb.append(", amount=").append(this.amount);
        sb.append(", currency=").append(this.currency);
        sb.append(", status=").append(this.status);
        sb.append(", isAdjusted=").append(this.isAdjusted);
        sb.append(", requestedDate=").append(this.requestedDate);
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", adjustments=").append(this.adjustments);
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int result = this.refundId != null ? this.refundId.hashCode() : 0;
        result = 31 * result + (this.paymentId != null ? this.paymentId.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.isAdjusted != null ? this.isAdjusted.hashCode() : 0);
        result = 31 * result + (this.requestedDate != null ? this.requestedDate.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.adjustments != null ? this.adjustments.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!this.equalsNoIdNoDates(obj)) {
            return false;
        }
        RefundJson other = (RefundJson)obj;
        if (this.refundId == null ? other.getRefundId() != null : !this.refundId.equals(other.getRefundId())) {
            return false;
        }
        if (this.requestedDate == null ? other.getRequestedDate() != null : this.requestedDate.compareTo((ReadableInstant)other.getRequestedDate()) != 0) {
            return false;
        }
        return !(this.effectiveDate == null ? other.getEffectiveDate() != null : this.effectiveDate.compareTo((ReadableInstant)other.getEffectiveDate()) != 0);
    }

    public boolean equalsNoIdNoDates(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefundJson other = (RefundJson)obj;
        if (this.isAdjusted == null ? other.isAdjusted != null : !this.isAdjusted.equals(other.isAdjusted)) {
            return false;
        }
        if (this.paymentId == null ? other.paymentId != null : !this.paymentId.equals(other.paymentId)) {
            return false;
        }
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        return !(this.adjustments == null ? other.adjustments != null : !this.adjustments.equals(other.adjustments));
    }
}

