/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.jaxrs.json.CatalogJsonSimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanDetailJson {
    final String productName;
    final String planName;
    final BillingPeriod billingPeriod;
    final String priceListName;
    final List<CatalogJsonSimple.PriceJson> finalPhasePrice;

    @JsonCreator
    public PlanDetailJson(@JsonProperty(value="product") String productName, @JsonProperty(value="plan") String planName, @JsonProperty(value="final_phase_billing_period") BillingPeriod billingPeriod, @JsonProperty(value="priceList") String priceListName, @JsonProperty(value="final_phase_recurring_price") List<CatalogJsonSimple.PriceJson> finalPhasePrice) {
        this.productName = productName;
        this.planName = planName;
        this.billingPeriod = billingPeriod;
        this.priceListName = priceListName;
        this.finalPhasePrice = finalPhasePrice;
    }

    public PlanDetailJson(Listing listing) {
        Plan plan = listing.getPlan();
        if (plan == null) {
            this.productName = null;
            this.planName = null;
            this.billingPeriod = null;
            this.finalPhasePrice = ImmutableList.of();
        } else {
            this.productName = plan.getProduct() == null ? null : plan.getProduct().getName();
            this.planName = plan.getName();
            this.billingPeriod = plan.getRecurringBillingPeriod();
            this.finalPhasePrice = plan.getFinalPhase() == null || plan.getFinalPhase().getRecurring() == null || plan.getFinalPhase().getRecurring().getRecurringPrice() == null || plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices() == null ? ImmutableList.of() : Lists.transform((List)ImmutableList.copyOf((Object[])plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()), (Function)new Function<Price, CatalogJsonSimple.PriceJson>(){

                public CatalogJsonSimple.PriceJson apply(Price price) {
                    try {
                        return new CatalogJsonSimple.PriceJson(price);
                    }
                    catch (CurrencyValueNull e) {
                        return new CatalogJsonSimple.PriceJson(price.getCurrency().toString(), BigDecimal.ZERO);
                    }
                }
            });
        }
        this.priceListName = listing.getPriceList() == null ? null : listing.getPriceList().getName();
    }

    public String getProductName() {
        return this.productName;
    }

    public String getPlanName() {
        return this.planName;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public String getPriceListName() {
        return this.priceListName;
    }

    public List<CatalogJsonSimple.PriceJson> getFinalPhasePrice() {
        return this.finalPhasePrice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PlanDetailJson{");
        sb.append("productName='").append(this.productName).append('\'');
        sb.append(", planName='").append(this.planName).append('\'');
        sb.append(", billingPeriod=").append(this.billingPeriod);
        sb.append(", priceListName='").append(this.priceListName).append('\'');
        sb.append(", finalPhasePrice=").append(this.finalPhasePrice);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanDetailJson that = (PlanDetailJson)o;
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        if (this.finalPhasePrice != null ? !this.finalPhasePrice.equals(that.finalPhasePrice) : that.finalPhasePrice != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.priceListName != null ? !this.priceListName.equals(that.priceListName) : that.priceListName != null) {
            return false;
        }
        return !(this.productName != null ? !this.productName.equals(that.productName) : that.productName != null);
    }

    public int hashCode() {
        int result = this.productName != null ? this.productName.hashCode() : 0;
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.priceListName != null ? this.priceListName.hashCode() : 0);
        result = 31 * result + (this.finalPhasePrice != null ? this.finalPhasePrice.hashCode() : 0);
        return result;
    }
}

