/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentMethodKVInfo;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethodJson
extends JsonBase {
    private final String paymentMethodId;
    private final String accountId;
    private final Boolean isDefault;
    private final String pluginName;
    private final PaymentMethodPluginDetailJson pluginInfo;

    @JsonCreator
    public PaymentMethodJson(@JsonProperty(value="paymentMethodId") String paymentMethodId, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="isDefault") Boolean isDefault, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="pluginInfo") PaymentMethodPluginDetailJson pluginInfo, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.paymentMethodId = paymentMethodId;
        this.accountId = accountId;
        this.isDefault = isDefault;
        this.pluginName = pluginName;
        this.pluginInfo = pluginInfo;
    }

    public static PaymentMethodJson toPaymentMethodJson(Account account, PaymentMethod in, @Nullable AccountAuditLogs accountAuditLogs) {
        boolean isDefault = account.getPaymentMethodId() != null && account.getPaymentMethodId().equals(in.getId());
        PaymentMethodPlugin pluginDetail = in.getPluginDetail();
        PaymentMethodPluginDetailJson pluginDetailJson = null;
        if (pluginDetail != null) {
            ArrayList<PaymentMethodProperties> properties = null;
            if (pluginDetail.getProperties() != null) {
                properties = new ArrayList<PaymentMethodProperties>(Collections2.transform((Collection)pluginDetail.getProperties(), (Function)new Function<PaymentMethodKVInfo, PaymentMethodProperties>(){

                    public PaymentMethodProperties apply(PaymentMethodKVInfo input) {
                        return new PaymentMethodProperties(input.getKey(), input.getValue() == null ? null : input.getValue().toString(), input.getIsUpdatable());
                    }
                }));
            }
            pluginDetailJson = new PaymentMethodPluginDetailJson(pluginDetail.getExternalPaymentMethodId(), pluginDetail.isDefaultPaymentMethod(), pluginDetail.getType(), pluginDetail.getCCName(), pluginDetail.getCCType(), pluginDetail.getCCExpirationMonth(), pluginDetail.getCCExpirationYear(), pluginDetail.getCCLast4(), pluginDetail.getAddress1(), pluginDetail.getAddress2(), pluginDetail.getCity(), pluginDetail.getState(), pluginDetail.getZip(), pluginDetail.getCountry(), properties);
        }
        return new PaymentMethodJson(in.getId().toString(), account.getId().toString(), isDefault, in.getPluginName(), pluginDetailJson, (List<AuditLogJson>)PaymentMethodJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForPaymentMethod(in.getId())));
    }

    public PaymentMethod toPaymentMethod(final String accountId) {
        return new PaymentMethod(){

            public Boolean isActive() {
                return true;
            }

            public String getPluginName() {
                return PaymentMethodJson.this.pluginName;
            }

            public UUID getId() {
                return PaymentMethodJson.this.paymentMethodId != null ? UUID.fromString(PaymentMethodJson.this.paymentMethodId) : null;
            }

            public DateTime getCreatedDate() {
                return null;
            }

            public DateTime getUpdatedDate() {
                return null;
            }

            public UUID getAccountId() {
                return UUID.fromString(accountId);
            }

            public PaymentMethodPlugin getPluginDetail() {
                return new PaymentMethodPlugin(){

                    public UUID getKbPaymentMethodId() {
                        return PaymentMethodJson.this.paymentMethodId == null ? null : UUID.fromString(PaymentMethodJson.this.paymentMethodId);
                    }

                    public boolean isDefaultPaymentMethod() {
                        return false;
                    }

                    public String getType() {
                        return null;
                    }

                    public String getCCName() {
                        return null;
                    }

                    public String getCCType() {
                        return null;
                    }

                    public String getCCExpirationMonth() {
                        return null;
                    }

                    public String getCCExpirationYear() {
                        return null;
                    }

                    public String getCCLast4() {
                        return null;
                    }

                    public String getAddress1() {
                        return null;
                    }

                    public String getAddress2() {
                        return null;
                    }

                    public String getCity() {
                        return null;
                    }

                    public String getState() {
                        return null;
                    }

                    public String getZip() {
                        return null;
                    }

                    public String getCountry() {
                        return null;
                    }

                    public String getExternalPaymentMethodId() {
                        return PaymentMethodJson.this.pluginInfo.getExternalPaymentId();
                    }

                    public List<PaymentMethodKVInfo> getProperties() {
                        if (PaymentMethodJson.this.pluginInfo.getProperties() != null) {
                            LinkedList<PaymentMethodKVInfo> result = new LinkedList<PaymentMethodKVInfo>();
                            for (PaymentMethodProperties cur : PaymentMethodJson.this.pluginInfo.getProperties()) {
                                result.add(new PaymentMethodKVInfo(cur.getKey(), (Object)cur.getValue(), cur.isUpdatable));
                            }
                            return result;
                        }
                        return null;
                    }
                };
            }
        };
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="isDefault")
    public Boolean isDefault() {
        return this.isDefault;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public PaymentMethodPluginDetailJson getPluginInfo() {
        return this.pluginInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PaymentMethodJson{");
        sb.append("paymentMethodId='").append(this.paymentMethodId).append('\'');
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append(", isDefault=").append(this.isDefault);
        sb.append(", pluginName='").append(this.pluginName).append('\'');
        sb.append(", pluginInfo=").append(this.pluginInfo);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodJson that = (PaymentMethodJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.isDefault != null ? !this.isDefault.equals(that.isDefault) : that.isDefault != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.pluginInfo != null ? !this.pluginInfo.equals(that.pluginInfo) : that.pluginInfo != null) {
            return false;
        }
        return !(this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null);
    }

    public int hashCode() {
        int result = this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0;
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.isDefault != null ? this.isDefault.hashCode() : 0);
        result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
        result = 31 * result + (this.pluginInfo != null ? this.pluginInfo.hashCode() : 0);
        return result;
    }

    public static final class PaymentMethodProperties {
        private final String key;
        private final String value;
        private final Boolean isUpdatable;

        @JsonCreator
        public PaymentMethodProperties(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="isUpdatable") Boolean isUpdatable) {
            this.key = key;
            this.value = value;
            this.isUpdatable = isUpdatable;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Boolean getIsUpdatable() {
            return this.isUpdatable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PaymentMethodProperties{");
            sb.append("key='").append(this.key).append('\'');
            sb.append(", value='").append(this.value).append('\'');
            sb.append(", isUpdatable=").append(this.isUpdatable);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaymentMethodProperties that = (PaymentMethodProperties)o;
            if (this.isUpdatable != null ? !this.isUpdatable.equals(that.isUpdatable) : that.isUpdatable != null) {
                return false;
            }
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.isUpdatable != null ? this.isUpdatable.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PaymentMethodPluginDetailJson {
        private final String externalPaymentId;
        private final Boolean isDefaultPaymentMethod;
        private final String type;
        private final String ccName;
        private final String ccType;
        private final String ccExpirationMonth;
        private final String ccExpirationYear;
        private final String ccLast4;
        private final String address1;
        private final String address2;
        private final String city;
        private final String state;
        private final String zip;
        private final String country;
        private final List<PaymentMethodProperties> properties;

        @JsonCreator
        public PaymentMethodPluginDetailJson(@JsonProperty(value="externalPaymentId") String externalPaymentId, @JsonProperty(value="isDefaultPaymentMethod") Boolean isDefaultPaymentMethod, @JsonProperty(value="type") String type, @JsonProperty(value="ccName") String ccName, @JsonProperty(value="ccType") String ccType, @JsonProperty(value="ccExpirationMonth") String ccExpirationMonth, @JsonProperty(value="ccExpirationYear") String ccExpirationYear, @JsonProperty(value="ccLast4") String ccLast4, @JsonProperty(value="address1") String address1, @JsonProperty(value="address2") String address2, @JsonProperty(value="city") String city, @JsonProperty(value="state") String state, @JsonProperty(value="zip") String zip, @JsonProperty(value="country") String country, @JsonProperty(value="properties") List<PaymentMethodProperties> properties) {
            this.externalPaymentId = externalPaymentId;
            this.isDefaultPaymentMethod = isDefaultPaymentMethod;
            this.type = type;
            this.ccName = ccName;
            this.ccType = ccType;
            this.ccExpirationMonth = ccExpirationMonth;
            this.ccExpirationYear = ccExpirationYear;
            this.ccLast4 = ccLast4;
            this.address1 = address1;
            this.address2 = address2;
            this.city = city;
            this.state = state;
            this.zip = zip;
            this.country = country;
            this.properties = properties;
        }

        public String getExternalPaymentId() {
            return this.externalPaymentId;
        }

        public Boolean getIsDefaultPaymentMethod() {
            return this.isDefaultPaymentMethod;
        }

        public String getType() {
            return this.type;
        }

        public String getCcName() {
            return this.ccName;
        }

        public String getCcType() {
            return this.ccType;
        }

        public String getCcExpirationMonth() {
            return this.ccExpirationMonth;
        }

        public String getCcExpirationYear() {
            return this.ccExpirationYear;
        }

        public String getCcLast4() {
            return this.ccLast4;
        }

        public String getAddress1() {
            return this.address1;
        }

        public String getAddress2() {
            return this.address2;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getZip() {
            return this.zip;
        }

        public String getCountry() {
            return this.country;
        }

        public List<PaymentMethodProperties> getProperties() {
            return this.properties;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PaymentMethodPluginDetailJson{");
            sb.append("externalPaymentId='").append(this.externalPaymentId).append('\'');
            sb.append(", isDefaultPaymentMethod=").append(this.isDefaultPaymentMethod);
            sb.append(", type='").append(this.type).append('\'');
            sb.append(", ccName='").append(this.ccName).append('\'');
            sb.append(", ccType='").append(this.ccType).append('\'');
            sb.append(", ccExpirationMonth='").append(this.ccExpirationMonth).append('\'');
            sb.append(", ccExpirationYear='").append(this.ccExpirationYear).append('\'');
            sb.append(", ccLast4='").append(this.ccLast4).append('\'');
            sb.append(", address1='").append(this.address1).append('\'');
            sb.append(", address2='").append(this.address2).append('\'');
            sb.append(", city='").append(this.city).append('\'');
            sb.append(", state='").append(this.state).append('\'');
            sb.append(", zip='").append(this.zip).append('\'');
            sb.append(", country='").append(this.country).append('\'');
            sb.append(", properties=").append(this.properties);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaymentMethodPluginDetailJson that = (PaymentMethodPluginDetailJson)o;
            if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) {
                return false;
            }
            if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) {
                return false;
            }
            if (this.ccExpirationMonth != null ? !this.ccExpirationMonth.equals(that.ccExpirationMonth) : that.ccExpirationMonth != null) {
                return false;
            }
            if (this.ccExpirationYear != null ? !this.ccExpirationYear.equals(that.ccExpirationYear) : that.ccExpirationYear != null) {
                return false;
            }
            if (this.ccLast4 != null ? !this.ccLast4.equals(that.ccLast4) : that.ccLast4 != null) {
                return false;
            }
            if (this.ccName != null ? !this.ccName.equals(that.ccName) : that.ccName != null) {
                return false;
            }
            if (this.ccType != null ? !this.ccType.equals(that.ccType) : that.ccType != null) {
                return false;
            }
            if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
                return false;
            }
            if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
                return false;
            }
            if (this.externalPaymentId != null ? !this.externalPaymentId.equals(that.externalPaymentId) : that.externalPaymentId != null) {
                return false;
            }
            if (this.isDefaultPaymentMethod != null ? !this.isDefaultPaymentMethod.equals(that.isDefaultPaymentMethod) : that.isDefaultPaymentMethod != null) {
                return false;
            }
            if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
                return false;
            }
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            return !(this.zip != null ? !this.zip.equals(that.zip) : that.zip != null);
        }

        public int hashCode() {
            int result = this.externalPaymentId != null ? this.externalPaymentId.hashCode() : 0;
            result = 31 * result + (this.isDefaultPaymentMethod != null ? this.isDefaultPaymentMethod.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.ccName != null ? this.ccName.hashCode() : 0);
            result = 31 * result + (this.ccType != null ? this.ccType.hashCode() : 0);
            result = 31 * result + (this.ccExpirationMonth != null ? this.ccExpirationMonth.hashCode() : 0);
            result = 31 * result + (this.ccExpirationYear != null ? this.ccExpirationYear.hashCode() : 0);
            result = 31 * result + (this.ccLast4 != null ? this.ccLast4.hashCode() : 0);
            result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
            result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
            result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.zip != null ? this.zip.hashCode() : 0);
            result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            return result;
        }
    }
}

