/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.ChargebackJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.RefundJson;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentAttempt;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.clock.DefaultClock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentJson
extends JsonBase {
    private final BigDecimal paidAmount;
    private final BigDecimal amount;
    private final String accountId;
    private final String invoiceId;
    private final String paymentId;
    private final String paymentNumber;
    private final DateTime requestedDate;
    private final DateTime effectiveDate;
    private final Integer retryCount;
    private final String currency;
    private final String status;
    private final String gatewayErrorCode;
    private final String gatewayErrorMsg;
    private final String paymentMethodId;
    private final String bundleKeys;
    private final List<RefundJson> refunds;
    private final List<ChargebackJson> chargebacks;

    @JsonCreator
    public PaymentJson(@JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="paidAmount") BigDecimal paidAmount, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="invoiceId") String invoiceId, @JsonProperty(value="paymentId") String paymentId, @JsonProperty(value="paymentNumber") String paymentNumber, @JsonProperty(value="paymentMethodId") String paymentMethodId, @JsonProperty(value="requestedDate") DateTime requestedDate, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="retryCount") Integer retryCount, @JsonProperty(value="currency") String currency, @JsonProperty(value="status") String status, @JsonProperty(value="gatewayErrorCode") String gatewayErrorCode, @JsonProperty(value="gatewayErrorMsg") String gatewayErrorMsg, @JsonProperty(value="externalBundleKeys") String bundleKeys, @JsonProperty(value="refunds") List<RefundJson> refunds, @JsonProperty(value="chargebacks") List<ChargebackJson> chargebacks, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.amount = amount;
        this.paidAmount = paidAmount;
        this.invoiceId = invoiceId;
        this.accountId = accountId;
        this.paymentId = paymentId;
        this.paymentNumber = paymentNumber;
        this.paymentMethodId = paymentMethodId;
        this.requestedDate = DefaultClock.toUTCDateTime((DateTime)requestedDate);
        this.effectiveDate = DefaultClock.toUTCDateTime((DateTime)effectiveDate);
        this.currency = currency;
        this.retryCount = retryCount;
        this.status = status;
        this.gatewayErrorCode = gatewayErrorCode;
        this.gatewayErrorMsg = gatewayErrorMsg;
        this.bundleKeys = bundleKeys;
        this.refunds = refunds;
        this.chargebacks = chargebacks;
    }

    public PaymentJson(Payment payment, String bundleExternalKey, List<RefundJson> refunds, List<ChargebackJson> chargebacks) {
        this(payment, bundleExternalKey, refunds, chargebacks, null);
    }

    public PaymentJson(Payment payment, String bundleExternalKey, List<RefundJson> refunds, List<ChargebackJson> chargebacks, @Nullable List<AuditLog> auditLogs) {
        this(payment.getAmount(), payment.getPaidAmount(), payment.getAccountId().toString(), payment.getInvoiceId().toString(), payment.getId().toString(), payment.getPaymentNumber().toString(), payment.getPaymentMethodId().toString(), payment.getEffectiveDate(), payment.getEffectiveDate(), payment.getAttempts().size(), payment.getCurrency().toString(), payment.getPaymentStatus().toString(), ((PaymentAttempt)payment.getAttempts().get(payment.getAttempts().size() - 1)).getGatewayErrorCode(), ((PaymentAttempt)payment.getAttempts().get(payment.getAttempts().size() - 1)).getGatewayErrorMsg(), bundleExternalKey, refunds, chargebacks, (List<AuditLogJson>)PaymentJson.toAuditLogJson(auditLogs));
    }

    public PaymentJson(Payment payment, List<AuditLog> auditLogs) {
        this(payment, null, null, null, auditLogs);
    }

    public String getBundleKeys() {
        return this.bundleKeys;
    }

    public BigDecimal getPaidAmount() {
        return this.paidAmount;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getPaymentNumber() {
        return this.paymentNumber;
    }

    public DateTime getRequestedDate() {
        return this.requestedDate;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getStatus() {
        return this.status;
    }

    public String getGatewayErrorCode() {
        return this.gatewayErrorCode;
    }

    public String getGatewayErrorMsg() {
        return this.gatewayErrorMsg;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public List<RefundJson> getRefunds() {
        return this.refunds;
    }

    public List<ChargebackJson> getChargebacks() {
        return this.chargebacks;
    }

    public String toString() {
        return "PaymentJson{paidAmount=" + this.paidAmount + ", amount=" + this.amount + ", accountId='" + this.accountId + '\'' + ", invoiceId='" + this.invoiceId + '\'' + ", paymentId='" + this.paymentId + '\'' + ", paymentNumber='" + this.paymentNumber + '\'' + ", requestedDate=" + this.requestedDate + ", effectiveDate=" + this.effectiveDate + ", retryCount=" + this.retryCount + ", currency='" + this.currency + '\'' + ", status='" + this.status + '\'' + ", gatewayErrorCode='" + this.gatewayErrorCode + '\'' + ", gatewayErrorMsg='" + this.gatewayErrorMsg + '\'' + ", paymentMethodId='" + this.paymentMethodId + '\'' + ", bundleKeys='" + this.bundleKeys + '\'' + ", refunds=" + this.refunds + ", chargebacks=" + this.chargebacks + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentJson that = (PaymentJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.bundleKeys != null ? !this.bundleKeys.equals(that.bundleKeys) : that.bundleKeys != null) {
            return false;
        }
        if (this.chargebacks != null ? !this.chargebacks.equals(that.chargebacks) : that.chargebacks != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.gatewayErrorCode != null ? !this.gatewayErrorCode.equals(that.gatewayErrorCode) : that.gatewayErrorCode != null) {
            return false;
        }
        if (this.gatewayErrorMsg != null ? !this.gatewayErrorMsg.equals(that.gatewayErrorMsg) : that.gatewayErrorMsg != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.paidAmount != null ? this.paidAmount.compareTo(that.paidAmount) != 0 : that.paidAmount != null) {
            return false;
        }
        if (this.paymentId != null ? !this.paymentId.equals(that.paymentId) : that.paymentId != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.paymentNumber != null ? !this.paymentNumber.equals(that.paymentNumber) : that.paymentNumber != null) {
            return false;
        }
        if (this.refunds != null ? !this.refunds.equals(that.refunds) : that.refunds != null) {
            return false;
        }
        if (this.requestedDate != null ? this.requestedDate.compareTo((ReadableInstant)that.requestedDate) != 0 : that.requestedDate != null) {
            return false;
        }
        if (this.retryCount != null ? !this.retryCount.equals(that.retryCount) : that.retryCount != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        int result = this.paidAmount != null ? this.paidAmount.hashCode() : 0;
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.paymentId != null ? this.paymentId.hashCode() : 0);
        result = 31 * result + (this.paymentNumber != null ? this.paymentNumber.hashCode() : 0);
        result = 31 * result + (this.requestedDate != null ? this.requestedDate.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.retryCount != null ? this.retryCount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.gatewayErrorCode != null ? this.gatewayErrorCode.hashCode() : 0);
        result = 31 * result + (this.gatewayErrorMsg != null ? this.gatewayErrorMsg.hashCode() : 0);
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.bundleKeys != null ? this.bundleKeys.hashCode() : 0);
        result = 31 * result + (this.refunds != null ? this.refunds.hashCode() : 0);
        result = 31 * result + (this.chargebacks != null ? this.chargebacks.hashCode() : 0);
        return result;
    }
}

