/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AuditLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditJson
extends JsonBase {
    private final BigDecimal creditAmount;
    private final String invoiceId;
    private final String invoiceNumber;
    private final LocalDate effectiveDate;
    private final String accountId;

    @JsonCreator
    public CreditJson(@JsonProperty(value="creditAmount") BigDecimal creditAmount, @JsonProperty(value="invoiceId") String invoiceId, @JsonProperty(value="invoiceNumber") String invoiceNumber, @JsonProperty(value="effectiveDate") LocalDate effectiveDate, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.creditAmount = creditAmount;
        this.invoiceId = invoiceId;
        this.invoiceNumber = invoiceNumber;
        this.effectiveDate = effectiveDate;
        this.accountId = accountId;
    }

    public CreditJson(Invoice invoice, InvoiceItem credit, List<AuditLog> auditLogs) {
        super((List<AuditLogJson>)CreditJson.toAuditLogJson(auditLogs));
        this.accountId = CreditJson.toString(credit.getAccountId());
        this.creditAmount = credit.getAmount();
        this.invoiceId = CreditJson.toString(credit.getInvoiceId());
        this.invoiceNumber = invoice.getInvoiceNumber().toString();
        this.effectiveDate = credit.getStartDate();
    }

    public CreditJson(Invoice invoice, InvoiceItem credit) {
        this(invoice, credit, null);
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CreditJson");
        sb.append("{creditAmount=").append(this.creditAmount);
        sb.append(", invoiceId=").append(this.invoiceId);
        sb.append(", invoiceNumber='").append(this.invoiceNumber).append('\'');
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", accountId=").append(this.accountId);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditJson that = (CreditJson)o;
        if (!(this.creditAmount == null && that.creditAmount == null || this.creditAmount != null && that.creditAmount != null && this.creditAmount.compareTo(that.creditAmount) == 0)) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.invoiceNumber != null ? !this.invoiceNumber.equals(that.invoiceNumber) : that.invoiceNumber != null) {
            return false;
        }
        return this.effectiveDate == null && that.effectiveDate == null || this.effectiveDate != null && that.effectiveDate != null && this.effectiveDate.compareTo((ReadablePartial)that.effectiveDate) == 0;
    }

    public int hashCode() {
        int result = this.creditAmount != null ? this.creditAmount.hashCode() : 0;
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.invoiceNumber != null ? this.invoiceNumber.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        return result;
    }
}

