/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.util.audit.AuditLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChargebackJson
extends JsonBase {
    private final String chargebackId;
    private final String accountId;
    private final DateTime requestedDate;
    private final DateTime effectiveDate;
    private final BigDecimal amount;
    private final String paymentId;
    private final String currency;

    @JsonCreator
    public ChargebackJson(@JsonProperty(value="chargebackId") String chargebackId, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="requestedDate") DateTime requestedDate, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="amount") BigDecimal chargebackAmount, @JsonProperty(value="paymentId") String paymentId, @JsonProperty(value="currency") String currency, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.chargebackId = chargebackId;
        this.accountId = accountId;
        this.requestedDate = requestedDate;
        this.effectiveDate = effectiveDate;
        this.amount = chargebackAmount;
        this.paymentId = paymentId;
        this.currency = currency;
    }

    public ChargebackJson(UUID accountId, InvoicePayment chargeback) {
        this(accountId, chargeback, null);
    }

    public ChargebackJson(UUID accountId, InvoicePayment chargeback, @Nullable List<AuditLog> auditLogs) {
        this(chargeback.getId().toString(), accountId.toString(), chargeback.getPaymentDate(), chargeback.getPaymentDate(), chargeback.getAmount().negate(), chargeback.getPaymentId().toString(), chargeback.getCurrency().toString(), (List<AuditLogJson>)ChargebackJson.toAuditLogJson(auditLogs));
    }

    public String getChargebackId() {
        return this.chargebackId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public DateTime getRequestedDate() {
        return this.requestedDate;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargebackJson that = (ChargebackJson)o;
        if (this.chargebackId != null ? !this.chargebackId.equals(that.chargebackId) : that.chargebackId != null) {
            return false;
        }
        if (!(this.amount == null && that.amount == null || this.amount != null && that.amount != null && this.amount.compareTo(that.amount) == 0)) {
            return false;
        }
        if (!(this.effectiveDate == null && that.effectiveDate == null || this.effectiveDate != null && that.effectiveDate != null && this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) == 0)) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.paymentId != null ? !this.paymentId.equals(that.paymentId) : that.paymentId != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        return this.requestedDate == null && that.requestedDate == null || this.requestedDate != null && that.requestedDate != null && this.requestedDate.compareTo((ReadableInstant)that.requestedDate) == 0;
    }

    public int hashCode() {
        int result = this.chargebackId != null ? this.chargebackId.hashCode() : 0;
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.requestedDate != null ? this.requestedDate.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.paymentId != null ? this.paymentId.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ChargebackJson{chargebackId='" + this.chargebackId + '\'' + ", accountId='" + this.accountId + '\'' + ", requestedDate=" + this.requestedDate + ", effectiveDate=" + this.effectiveDate + ", amount=" + this.amount + ", paymentId='" + this.paymentId + '\'' + ", currency='" + this.currency + '\'' + '}';
    }
}

