/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.entitlement.api.SubscriptionEvent;
import org.killbill.billing.jaxrs.json.AuditLogJson;
import org.killbill.billing.jaxrs.json.JsonBase;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleJson
extends JsonBase {
    protected final String accountId;
    protected final String bundleId;
    protected final String externalKey;
    private final List<SubscriptionJson> subscriptions;

    @JsonCreator
    public BundleJson(@JsonProperty(value="accountId") @Nullable String accountId, @JsonProperty(value="bundleId") @Nullable String bundleId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="subscriptions") @Nullable List<SubscriptionJson> subscriptions, @JsonProperty(value="auditLogs") @Nullable List<AuditLogJson> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.externalKey = externalKey;
        this.subscriptions = subscriptions;
    }

    @JsonProperty(value="subscriptions")
    public List<SubscriptionJson> getSubscriptions() {
        return this.subscriptions;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public BundleJson(SubscriptionBundle bundle, @Nullable AccountAuditLogs accountAuditLogs) {
        super((List<AuditLogJson>)BundleJson.toAuditLogJson(accountAuditLogs == null ? null : accountAuditLogs.getAuditLogsForBundle(bundle.getId())));
        this.accountId = bundle.getAccountId().toString();
        this.bundleId = bundle.getId().toString();
        this.externalKey = bundle.getExternalKey();
        this.subscriptions = new LinkedList<SubscriptionJson>();
        for (final Subscription cur : bundle.getSubscriptions()) {
            ImmutableList events = ImmutableList.copyOf((Collection)Collections2.filter((Collection)bundle.getTimeline().getSubscriptionEvents(), (Predicate)new Predicate<SubscriptionEvent>(){

                public boolean apply(@Nullable SubscriptionEvent input) {
                    return input.getEntitlementId().equals(cur.getId());
                }
            }));
            this.subscriptions.add(new SubscriptionJson(cur, (List<SubscriptionEvent>)events, accountAuditLogs));
        }
    }

    public String toString() {
        return "BundleJson{accountId='" + this.accountId + '\'' + ", bundleId='" + this.bundleId + '\'' + ", externalKey='" + this.externalKey + '\'' + ", subscriptions=" + this.subscriptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleJson that = (BundleJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        return !(this.subscriptions != null ? !this.subscriptions.equals(that.subscriptions) : that.subscriptions != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.subscriptions != null ? this.subscriptions.hashCode() : 0);
        return result;
    }
}

