/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.util.audit.AuditLog;

public class AuditLogJson {
    private final String changeType;
    private final DateTime changeDate;
    private final String changedBy;
    private final String reasonCode;
    private final String comments;
    private final String userToken;

    @JsonCreator
    public AuditLogJson(@JsonProperty(value="changeType") String changeType, @JsonProperty(value="changeDate") DateTime changeDate, @JsonProperty(value="changedBy") String changedBy, @JsonProperty(value="reasonCode") String reasonCode, @JsonProperty(value="comments") String comments, @JsonProperty(value="userToken") String userToken) {
        this.changeType = changeType;
        this.changeDate = changeDate;
        this.changedBy = changedBy;
        this.reasonCode = reasonCode;
        this.comments = comments;
        this.userToken = userToken;
    }

    public AuditLogJson(AuditLog auditLog) {
        this(auditLog.getChangeType().toString(), auditLog.getCreatedDate(), auditLog.getUserName(), auditLog.getReasonCode(), auditLog.getComment(), auditLog.getUserToken());
    }

    public String getChangeType() {
        return this.changeType;
    }

    public DateTime getChangeDate() {
        return this.changeDate;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getComments() {
        return this.comments;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditLogJson");
        sb.append("{changeType='").append(this.changeType).append('\'');
        sb.append(", changeDate=").append(this.changeDate);
        sb.append(", changedBy=").append(this.changedBy);
        sb.append(", reasonCode='").append(this.reasonCode).append('\'');
        sb.append(", comments='").append(this.comments).append('\'');
        sb.append(", userToken='").append(this.userToken).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogJson that = (AuditLogJson)o;
        if (this.changeDate != null ? this.changeDate.compareTo((ReadableInstant)that.changeDate) != 0 : that.changeDate != null) {
            return false;
        }
        if (this.changeType != null ? !this.changeType.equals(that.changeType) : that.changeType != null) {
            return false;
        }
        if (this.changedBy != null ? !this.changedBy.equals(that.changedBy) : that.changedBy != null) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.reasonCode != null ? !this.reasonCode.equals(that.reasonCode) : that.reasonCode != null) {
            return false;
        }
        return !(this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null);
    }

    public int hashCode() {
        int result = this.changeType != null ? this.changeType.hashCode() : 0;
        result = 31 * result + (this.changeDate != null ? this.changeDate.hashCode() : 0);
        result = 31 * result + (this.changedBy != null ? this.changedBy.hashCode() : 0);
        result = 31 * result + (this.reasonCode != null ? this.reasonCode.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.userToken != null ? this.userToken.hashCode() : 0);
        return result;
    }
}

