/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.jaxrs.json.AccountJson;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.ChargebackJson;
import org.killbill.billing.jaxrs.json.CreditJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.RefundJson;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.Refund;
import org.killbill.billing.util.audit.AccountAuditLogs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountTimelineJson {
    private final AccountJson account;
    private final List<BundleJson> bundles;
    private final List<InvoiceJson> invoices;
    private final List<PaymentJson> payments;

    @JsonCreator
    public AccountTimelineJson(@JsonProperty(value="account") AccountJson account, @JsonProperty(value="bundles") List<BundleJson> bundles, @JsonProperty(value="invoices") List<InvoiceJson> invoices, @JsonProperty(value="payments") List<PaymentJson> payments) {
        this.account = account;
        this.bundles = bundles;
        this.invoices = invoices;
        this.payments = payments;
    }

    private String getBundleExternalKey(UUID invoiceId, List<Invoice> invoices, List<SubscriptionBundle> bundles) {
        for (Invoice cur : invoices) {
            if (!cur.getId().equals(invoiceId)) continue;
            return this.getBundleExternalKey(cur, bundles);
        }
        return null;
    }

    private String getBundleExternalKey(Invoice invoice, List<SubscriptionBundle> bundles) {
        HashSet<UUID> b = new HashSet<UUID>();
        for (InvoiceItem cur : invoice.getInvoiceItems()) {
            b.add(cur.getBundleId());
        }
        boolean first = true;
        StringBuilder tmp = new StringBuilder();
        block1: for (UUID cur : b) {
            for (SubscriptionBundle bt : bundles) {
                if (!bt.getId().equals(cur)) continue;
                if (!first) {
                    tmp.append(",");
                }
                tmp.append(bt.getExternalKey());
                first = false;
                continue block1;
            }
        }
        return tmp.toString();
    }

    public AccountTimelineJson(Account account, List<Invoice> invoices, List<Payment> payments, List<SubscriptionBundle> bundles, Multimap<UUID, Refund> refundsByPayment, Multimap<UUID, InvoicePayment> chargebacksByPayment, AccountAuditLogs accountAuditLogs) {
        List auditLogs;
        this.account = new AccountJson(account, null, null, accountAuditLogs);
        this.bundles = new LinkedList<BundleJson>();
        for (SubscriptionBundle bundle : bundles) {
            List bundleAuditLogs = accountAuditLogs.getAuditLogsForBundle(bundle.getId());
            BundleJson jsonWithSubscriptions = new BundleJson(bundle, accountAuditLogs);
            this.bundles.add(jsonWithSubscriptions);
        }
        this.invoices = new LinkedList<InvoiceJson>();
        ArrayList<CreditJson> credits = new ArrayList<CreditJson>();
        for (Invoice invoice : invoices) {
            for (InvoiceItem invoiceItem : invoice.getInvoiceItems()) {
                if (!InvoiceItemType.CREDIT_ADJ.equals((Object)invoiceItem.getInvoiceItemType())) continue;
                auditLogs = accountAuditLogs.getAuditLogsForInvoiceItem(invoiceItem.getId());
                credits.add(new CreditJson(invoice, invoiceItem, auditLogs));
            }
        }
        for (Invoice invoice : invoices) {
            List auditLogs2 = accountAuditLogs.getAuditLogsForInvoice(invoice.getId());
            this.invoices.add(new InvoiceJson(invoice, this.getBundleExternalKey(invoice, bundles), credits, auditLogs2));
        }
        this.payments = new LinkedList<PaymentJson>();
        for (Payment payment : payments) {
            ArrayList<RefundJson> refunds = new ArrayList<RefundJson>();
            for (Refund refund : refundsByPayment.get((Object)payment.getId())) {
                List auditLogs3 = accountAuditLogs.getAuditLogsForRefund(refund.getId());
                refunds.add(new RefundJson(refund, null, auditLogs3));
            }
            ArrayList<ChargebackJson> chargebacks = new ArrayList<ChargebackJson>();
            for (InvoicePayment chargeback : chargebacksByPayment.get((Object)payment.getId())) {
                List auditLogs4 = accountAuditLogs.getAuditLogsForChargeback(chargeback.getId());
                chargebacks.add(new ChargebackJson(payment.getAccountId(), chargeback, auditLogs4));
            }
            auditLogs = accountAuditLogs.getAuditLogsForPayment(payment.getId());
            this.payments.add(new PaymentJson(payment, this.getBundleExternalKey(payment.getInvoiceId(), invoices, bundles), refunds, chargebacks, auditLogs));
        }
    }

    public AccountJson getAccount() {
        return this.account;
    }

    public List<BundleJson> getBundles() {
        return this.bundles;
    }

    public List<InvoiceJson> getInvoices() {
        return this.invoices;
    }

    public List<PaymentJson> getPayments() {
        return this.payments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccountTimelineJson");
        sb.append("{account=").append(this.account);
        sb.append(", bundles=").append(this.bundles);
        sb.append(", invoices=").append(this.invoices);
        sb.append(", payments=").append(this.payments);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountTimelineJson that = (AccountTimelineJson)o;
        if (this.account != null ? !this.account.equals(that.account) : that.account != null) {
            return false;
        }
        if (this.bundles != null ? !this.bundles.equals(that.bundles) : that.bundles != null) {
            return false;
        }
        if (this.invoices != null ? !this.invoices.equals(that.invoices) : that.invoices != null) {
            return false;
        }
        return !(this.payments != null ? !this.payments.equals(that.payments) : that.payments != null);
    }

    public int hashCode() {
        int result = this.account != null ? this.account.hashCode() : 0;
        result = 31 * result + (this.bundles != null ? this.bundles.hashCode() : 0);
        result = 31 * result + (this.invoices != null ? this.invoices.hashCode() : 0);
        result = 31 * result + (this.payments != null ? this.payments.hashCode() : 0);
        return result;
    }
}

